\name{duncan.test}
\alias{duncan.test}
%- duncan.
\title{ Duncan's new multiple range test }
\description{
  This test is adapted from the Newman-Keuls method. Duncan's test does not control family wise error rate at the specified alpha level. It has more power than the other post tests, but only because it doesn't control the error rate properly. The Experimentwise Error Rate at: 1-(1-alpha)^(a-1); where "a" is the number of means and is the Per-Comparison Error Rate. Duncan's procedure is only very slightly more conservative than LSD. The level by alpha default is 0.05.
}
\usage{
duncan.test(y, trt, DFerror, MSerror, alpha = 0.05, group=TRUE, main = NULL,console=FALSE)
}

\arguments{
  \item{y}{ model(aov or lm) or answer of the experimental unit  }
  \item{trt}{ Constant( only y=model) or vector treatment applied to each experimental unit  }
  \item{DFerror}{ Degree free }
  \item{MSerror}{ Mean Square Error }
  \item{alpha}{ Significant level }
  \item{group}{ TRUE or FALSE }
  \item{main}{ Title }
  \item{console}{logical, print output }
}
\details{
  It is necessary first makes a analysis of variance.
}
\value{

  \item{y }{class (aov or lm) or vector numeric}
  \item{trt }{constant (only y=model) or vector alfanumeric}
  \item{DFerror }{Numeric}
  \item{MSerror }{Numeric}
  \item{alpha }{Numeric}
  \item{group}{ Logic}  
  \item{main }{Text}

}
\references{  
1. Principles and procedures of statistics a biometrical approach
   Steel & Torry & Dickey. Third Edition 1997
2. Multiple comparisons theory and methods. Departament of statistics 
   the Ohio State University. USA, 1996. Jason C. Hsu. Chapman Hall/CRC.
}

\author{ Felipe de Mendiburu }

\seealso{\code{\link{LSD.test}}, \code{\link{waller.test} },
 \code{\link{HSD.test} }, \code{\link{SNK.test} } }

\examples{
library(agricolae)
data(sweetpotato)
model<-aov(yield~virus,data=sweetpotato)
comparison <- duncan.test(model,"virus", 
main="Yield of sweetpotato. Dealt with different virus")
duncan.test(model,"virus",alpha=0.01,console=TRUE)
# version old duncan.test()
attach(sweetpotato)
df<-df.residual(model)
MSerror<-deviance(model)/df
comparison <- duncan.test(yield,virus,df,MSerror, group=TRUE)
print(comparison$groups)
detach(sweetpotato)
}
\keyword{ htest }% at least one, from doc/KEYWORDS

