% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpATS.R
\name{h_cullis_spt}
\alias{h_cullis_spt}
\title{Calculate Cullis heritabilities from SpATS objects}
\usage{
h_cullis_spt(model)
}
\arguments{
\item{model}{an object of class SpATS as produced by SpATS()}
}
\value{
A data frame.  The data frame has the following components
\itemize{
\item \code{trait} : Character string with the trait being analyzed
\item \code{H2Cullis} : Generalized heritability proposed by Cullis (2006)
\item \code{H2Oakey} :  Generalized heritability proposed by Oakey (2006)
\item \code{reBLUP_avg} : Average BLUP reliability
\item \code{vdBLUP_avg} : Average pairwise prediction error variance of genotype effects
\item \code{PEV_avg} : Average predictive error variance (PEV) of genotype effects
\item \code{var_G} : Genotypic Variance
}
}
\description{
Calculate Cullis heritabilities from SpATS objects
}
\examples{
\donttest{
library(SpATS)
library(agriutilities)
data(wheatdata)
wheatdata$R <- as.factor(wheatdata$row)
wheatdata$C <- as.factor(wheatdata$col)

m1 <- SpATS(
  response = "yield",
  spatial = ~ PSANOVA(col, row, nseg = c(10, 20), nest.div = 2),
  genotype = "geno",
  genotype.as.random = TRUE,
  fixed = ~ colcode + rowcode,
  random = ~ R + C,
  data = wheatdata,
  control = list(tolerance = 1e-03, monitoring = 0)
)

h_cullis_spt(m1)
}
}
\references{
Cullis, B. R., Smith, A. B., & Coombes, N. E. (2006).
On the design of early generation variety trials with correlated data.
Journal of agricultural, biological, and environmental statistics, 11, 381-393.

Oakey, H., A. Verbyla, W. Pitchford, B. Cullis, and H. Kuchel (2006).
Joint modeling of additive and non-additive genetic line effects in single
field trials. Theoretical and Applied Genetics, 113, 809 - 819.
}
\author{
Johan Aparicio
}
