% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_zone_data.R
\name{get_zone_data}
\alias{get_zone_data}
\title{Download pollution data by zone}
\usage{
get_zone_data(criterion, pollutant, zone, start_date, end_date,
  showWarnings = TRUE)
}
\arguments{
\item{criterion}{The type of data to download
\itemize{
 \item{"HORARIOS"}{ - Hourly data}
 \item{"MAXIMOS""}{ - Daily maximums}
}}

\item{pollutant}{The type of pollutant to download
\itemize{
 \item{"SO2"}{ - Dioxido de azufre}
 \item{"CO"}{ - Monoxido de carbono}
 \item{"NO2"}{ - Dioxido de nitrogeno}
 \item{"O3"}{ - Ozono}
 \item{"PM10"}{ - Particulas menores a 10 micrometros}
 \item{"TC"}{- All the pollutants}
}}

\item{zone}{The geographic zone for which to download data
\itemize{
 \item{"NO"}{ - Noroeste}
 \item{"NE"}{ - Noreste}
 \item{"CE"}{ - Centro}
 \item{"SO"}{ - Suroeste}
 \item{"SE"}{ - Sureste}
 \item{"TZ"}{ - All the zones}
}}

\item{start_date}{The start date in YYYY-MM-DD format (earliest possible value is 2008-01-01).}

\item{end_date}{The end date in YYYY-MM-DD format.}

\item{showWarnings}{Show warnings about problems with the data}
}
\value{
A data.frame with pollution data measured in IMECAS, by geographic zone
}
\description{
retrieve pollution data in IMECAs by geographic zone from the air quality server at \url{http://www.aire.cdmx.gob.mx/default.php?opc='aqBjnmU='}
}
\examples{
## There was a regional (NE) PM10 pollution emergency on Jan 6, 2017
get_zone_data("MAXIMOS", "PM10", "NE", "2017-01-05", "2017-01-08", showWarnings = FALSE)
## There was an ozone pollution emergency on May 15, 2017
get_zone_data("MAXIMOS", "O3", "TZ", "2017-05-15", "2017-05-15", showWarnings = FALSE)
\dontrun{
## Download daily maximum PM10 data (particulate matter 10 micrometers or less in diameter)
## from 2015-01-01 to 2016-03-20 for all geographic zones
df <- get_zone_data("MAXIMOS", "PM10", "TZ", "2015-01-01", "2016-03-20")
head(df)
}

}
