% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_zone_imeca.R
\name{get_zone_imeca}
\alias{get_zone_imeca}
\title{Download pollution data by zone in IMECAs}
\usage{
get_zone_imeca(
  criterion,
  pollutant,
  zone,
  start_date,
  end_date,
  showWarnings = TRUE,
  show_messages = TRUE
)
}
\arguments{
\item{criterion}{The type of data to download. One of the following options:
\itemize{
 \item HORARIOS - Hourly data
 \item MAXIMOS" - Daily maximums
}}

\item{pollutant}{The type of pollutant to download. One or more of the
following options:
\itemize{
 \item SO2 - Sulfur Dioxide
 \item CO - Carbon Monoxide
 \item NO2 - Nitrogen Dioxide
 \item O3 - Ozone
 \item PM10 - Particulate matter 10 micrometers or less
 \item TC - All the pollutants
}}

\item{zone}{The geographic zone for which to download data. One or more of
the following:
\itemize{
 \item NO - Noroeste
 \item NE - Noreste
 \item CE - Centro
 \item SO - Suroeste
 \item SE - Sureste
 \item TZ - All zones
}}

\item{start_date}{The start date in YYYY-MM-DD format (earliest possible
value is 2008-01-01).}

\item{end_date}{The end date in YYYY-MM-DD format.}

\item{showWarnings}{deprecated; you can use the function
\code{\link[base]{suppressWarnings}} instead.}

\item{show_messages}{show a message about issues with performing the
conversion}
}
\value{
A data.frame with pollution data measured in IMECAs, by geographic
  zone. The hours correspond to the \emph{Etc/GMT+6} timezone, with no
  daylight saving time
}
\description{
Retrieve pollution data in IMECAs by geographic zone from the air quality
server at \href{http://www.aire.cdmx.gob.mx/aire/default.php?opc=\%27aqBjnmU=\%27}{Consultas}
}
\details{
Note that in 2015 it was determined that the stations with codes ACO, AJU,
INN, MON and MPA would no longer be taken into consideration when computing
the pollution index because they didn't meet the
\href{http://www.aire.cdmx.gob.mx/aire/objetivos-monitoreo-calidad-aire.html}{objectives
of monitoring air quality}. They are no longer included in the index, even if
they are still part of the SIMAT (Sistema de Monitoreo Atmosférico de la
Ciudad de México). Thus, even if they are located inside a zone, they are not
included in the pollution values for that zone.

The different geographic zones were defined in the
\href{http://www.aire.cdmx.gob.mx/aire/descargas/ultima-hora/calidad-aire/pcaa/Gaceta_Oficial_CDMX.pdf}{ Gaceta Oficial de la Ciudad de México}
No. 230, 27 de Diciembre de 2016.

\strong{Zona Centro}: Benito Juárez,
Cuauhtémoc, Iztacalco and Venustiano Carranza.

\strong{Zona Noreste}: Gustavo A. Madero, Coacalco de Berriozábal,
Chicoloapan, Chimalhuacán,
Ecatepec de Morelos, Ixtapaluca, La Paz,
Nezahualcóyotl and Tecámac.

\strong{Zona Noroeste}: Azcapotzalco,
Miguel Hidalgo, Atizapán de Zaragoza, Cuautitlán, Cuautitlán Izcalli,
Naucalpan de Juárez, Nicolás
Romero, Tlalnepantla de Baz and Tultitlán.

\strong{Zona Sureste}: Iztapalapa, Milpa
Alta, Tláhuac, Xochimilco, Chalco and Valle de Chalco.

\strong{Zona Suroeste}: Álvaro Obregón,
Coyoacán, Cuajimalpa, Magdalena Contreras, Tlalpan and Huixquilucan.
}
\examples{
\donttest{
## There was a regional (NE) PM10 pollution emergency on Jan 6, 2017
get_zone_imeca("MAXIMOS", "PM10", "NE", "2017-01-05", "2017-01-08",
               show_messages = FALSE)

## There was an ozone pollution emergency on May 15, 2017
get_zone_imeca("MAXIMOS", "O3", "TZ", "2017-05-15", "2017-05-15",
               show_messages = FALSE)

}
\dontrun{
## Download daily maximum PM10 data (particulate matter 10 micrometers or
## less in diameter) from 2015-01-01 to 2016-03-20 for all geographic zones
df <- get_zone_imeca("MAXIMOS", "PM10", "TZ", "2015-01-01", "2016-03-20")
head(df)

## Download hourly O3 pollution data for May 15, 2017. Only the suroeste zone
df2 <- get_zone_imeca("HORARIOS", "O3", "SO", "2017-05-15", "2017-05-15")

## Convert to local Mexico City time
df2$mxc_time <- format(as.POSIXct(paste0(df2$date, " ", df2$hour, ":00"),
                                  tz = "Etc/GMT+6"),
                       tz = "America/Mexico_City")

head(df2)
}

}
\seealso{
\code{\link{zones}} a data.frame containing the municipios
  belonging to each zone, and
  \href{http://www.aire.cdmx.gob.mx/aire/default.php?opc=\%27aqBjnmI=\%27}{Índice de
  calidad del aire por zonas}

Other IMECA functions: 
\code{\link{get_latest_imeca}()},
\code{\link{get_station_imeca}()}
}
\concept{IMECA functions}
