% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyword_group.R
\name{keyword_group}
\alias{keyword_group}
\title{Construct network from a tidy table and divide them into groups}
\usage{
keyword_group(
  dt,
  id = "id",
  keyword = "keyword",
  top = 200,
  min_freq = 1,
  com_detect_fun = group_fast_greedy
)
}
\arguments{
\item{dt}{A data.frame containing at least two columns with document ID and keyword.}

\item{id}{Quoted characters specifying the column name of document ID.Default uses "id".}

\item{keyword}{Quoted characters specifying the column name of keyword.Default uses "keyword".}

\item{top}{The number of keywords selected with the largest frequency.
If there is a tie,more than \emph{top} entries would be selected.}

\item{min_freq}{Minimum occurrence of selected keywords.Default uses 1.}

\item{com_detect_fun}{Community detection function,provided by \pkg{tidygraph}(wrappers around clustering
functions provided by \pkg{igraph}), see \code{\link[tidygraph]{group_graph}} to find other optional algorithms.
Default uses \code{\link[tidygraph]{group_fast_greedy}}.}
}
\value{
A tbl_graph, representing the keyword co-occurence network with frequency and group
number of the keywords.
}
\description{
Create a \code{tbl_graph}(a class provided by \pkg{tidygraph}) from the tidy table with document ID and keyword.
Each entry(row) should contain only one keyword in the tidy format.This function would automatically computes
the frequency and classification group number of nodes representing keywords.
}
\details{
This function receives a tidy table with document ID and keyword.Only top keywords with
largest frequency would be selected and the minimum occurrence of keywords could be specified.
For suggestions of community detection algorithm, see the references provided below.
}
\examples{
library(akc)

bibli_data_table \%>\%
  keyword_clean(id = "id",keyword = "keyword") \%>\%
  keyword_group(id = "id",keyword = "keyword")

# use 'louvain' algorithm for community detection

bibli_data_table \%>\%
  keyword_clean(id = "id",keyword = "keyword") \%>\%
  keyword_group(id = "id",keyword = "keyword",
  com_detect_fun = group_louvain)

# get more alternatives by searching '?tidygraph::group_graph'

}
\references{
de Sousa, Fabiano Berardo, and Liang Zhao. "Evaluating and comparing the igraph community detection algorithms." 2014 Brazilian Conference on Intelligent Systems. IEEE, 2014.\url{https://ieeexplore_ieee.xilesou.top/abstract/document/6984865/}

Yang, Z., Algesheimer, R., & Tessone, C. J. (2016). A comparative analysis of community detection algorithms on artificial networks. Scientific reports, 6, 30750.\url{https://www_nature.xilesou.top/articles/srep30750}
}
\seealso{
\code{\link[tidygraph]{tbl_graph}}, \code{\link[tidygraph]{group_graph}}
}
