% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity.R
\name{calcCoverage}
\alias{calcCoverage}
\title{Calculate sample coverage}
\usage{
calcCoverage(x, r = 1)
}
\arguments{
\item{x}{numeric vector of abundance counts.}

\item{r}{coverage order to calculate.}
}
\value{
The sample coverage of the given order \code{r}.
}
\description{
\code{calcCoverage} calculates the sample coverage estimate, a measure of sample 
completeness, for varying orders using the method of Chao et al, 2015, falling back 
to the Chao1 method in the first order case.
}
\examples{
# Calculate clone sizes
clones <- countClones(ExampleDb, groups="sample_id")

# Calculate 1first order coverage for a single sample
calcCoverage(clones$seq_count[clones$sample_id == "+7d"])

}
\references{
\enumerate{
  \item  Chao A. Nonparametric Estimation of the Number of Classes in a Population. 
           Scand J Stat. 1984 11, 265270.
  \item  Chao A, et al. Unveiling the species-rank abundance distribution by 
           generalizing the Good-Turing sample coverage theory. 
           Ecology. 2015 96, 11891201.
}
}
\seealso{
Used by \link{alphaDiversity}.
}
