% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_to_mfg_df.r
\name{traits_to_mfg_df}
\alias{traits_to_mfg_df}
\title{Assign morphofunctional groups to a dataframe of functional traits and higher taxonomy}
\usage{
traits_to_mfg_df(dframe, arg.names = c("flagella", "size", "colonial",
  "filament", "centric", "gelatinous", "aerotopes", "class", "order"))
}
\arguments{
\item{dframe}{An R dataframe containing functional trait information and higher taxonomy}

\item{arg.names}{Character string of column names corresponding to arguments for traits_to_mfg()}
}
\value{
A character vector containing morpho-functional group (MFG) designations
}
\description{
Assign morphofunctional groups to a dataframe of functional traits and higher taxonomy
}
\examples{
#create a two-row example dataframe of functional traits
func.dframe=data.frame(flag=1,size=c("large","small"),col=0,fil=0,cent=NA,gel=0,
                       aer=0,cl="Euglenophyceae",or="Euglenales",stringsAsFactors=FALSE)
                       
#check the dataframe                       
print(func.dframe)                        

#run the function to produce a two-element character vector
traits_to_mfg_df(func.dframe,c("flag","size","col","fil","cent","gel","aer","cl","or"))
}
