% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_search_itis.r
\name{species_search_itis}
\alias{species_search_itis}
\title{Wrapper function for several functions in ritis::
Searches ITIS database for matches to a binomial scientific name
outputs matches, current accepted names, synonyms, and higher taxonomy}
\usage{
species_search_itis(genspp, higher = FALSE)
}
\arguments{
\item{genspp}{Character string. Binomial scientific name with space between genus
and species.}

\item{higher}{Boolean. If TRUE, add higher taxonomic classifications to output}
}
\value{
data.frame with submitted name (orig.name), matched name (matched.name),
1/0 flag indicating that original name is currently accepted (orig.name.accepted),
1/0 flag indicating if search was genus_only (for distinguishing genus_search_itis
and species_search_itis results), synonyms if any, and higher taxonomy (if
higher=TRUE)
}
\description{
Wrapper function for several functions in ritis::
Searches ITIS database for matches to a binomial scientific name
outputs matches, current accepted names, synonyms, and higher taxonomy
}
\examples{
species="Aphanizomenon flosaquae"
species_search_itis(species,higher=TRUE)
}
