% Generated by roxygen2 (4.0.1): do not edit by hand
\name{latteMax}
\alias{latteMax}
\title{Solve a Linear Program (Maximization)}
\usage{
latteMax(objective, constraints, method = c("lp", "cones"), dir = tempdir(),
  opts = "", quiet = TRUE)
}
\arguments{
\item{objective}{a linear polynomial to pass to \code{\link{mp}}, see examples}

\item{constraints}{a collection of linear polynomial (in)equalities that define the feasibility region, the integers in the polytope}

\item{method}{method LP or cones}

\item{dir}{directory to place the files in, without an ending /}

\item{opts}{options; see the LattE manual at \url{http://www.math.ucdavis.edu/~latte}}

\item{quiet}{show latte output}
}
\value{
the count.  if the count is a number has less than 10 digits, an integer is returned.  if the number has 10 or more digits, an integer in a character string is returned. you may want to use the gmp package's as.bigz to parse it.
}
\description{
\code{latteMax} uses LattE's maximize function to find the maximum of a linear objective function over the integers satisfying linearity constraints.  This makes use of the digging algorithm; see the LattE manual at \url{http://www.math.ucdavis.edu/~latte} for details.
}
\examples{
\dontrun{

latteMax("-2 x + 3 y", c("x + y <= 10", "x >= 0", "y >= 0"))


df <- expand.grid(x = 0:10, y = 0:10)
df <- subset(df, x + y <= 10)
df$val <- apply(df, 1, function(v) -2*v[1] + 3*v[2])
df[which.max(df$val),]

library(ggplot2)
qplot(x, y, data = df, size = val)



}
}

