% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/baseline.R
\docType{methods}
\name{baseline_snip}
\alias{baseline_snip}
\alias{baseline_snip-method}
\alias{baseline_snip,numeric,numeric-method}
\alias{baseline_snip,ANY,missing-method}
\title{SNIP Baseline Estimation}
\usage{
baseline_snip(x, y, ...)

\S4method{baseline_snip}{numeric,numeric}(x, y, LLS = FALSE, decreasing = FALSE, n = 100)

\S4method{baseline_snip}{ANY,missing}(x, LLS = FALSE, decreasing = FALSE, n = 100)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{LLS}{A \code{\link{logical}} scalar: should the LLS operator be applied on \code{x}
before employing SNIP algorithm? Only used if \code{method} is "\code{SNIP}".}

\item{decreasing}{A \code{\link{logical}} scalar: should a decreasing clipping window
be used?}

\item{n}{An \code{\link{integer}} value giving the number of iterations.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Sensitive Nonlinear Iterative Peak clipping algorithm.
}
\examples{
## gamma-ray spectrometry
data("BEGe")

## Subset from 2.75 to 200 keV
BEGe <- signal_select(BEGe, from = 3, to = 200)

## Plot spectrum
plot(BEGe, type = "l", xlab = "Energy (keV)", ylab = "Count")

## SNIP baseline
baseline <- baseline_snip(BEGe, LLS = FALSE, decreasing = FALSE, n = 100)

plot(BEGe, type = "l", xlab = "Energy (keV)", ylab = "Count")
lines(baseline, type = "l", col = "red")
}
\references{
Morháč, M., Kliman, J., Matoušek, V., Veselský, M. & Turzo, I. (1997).
Background elimination methods for multidimensional gamma-ray spectra.
\emph{Nuclear Instruments and Methods in Physics Research Section A:
Accelerators, Spectrometers, Detectors and Associated Equipment}, 401(1),
p. 113-132. \doi{10.1016/S0168-9002(97)01023-1}

Morháč, M. & Matoušek, V. (2008). Peak Clipping Algorithms for Background
Estimation in Spectroscopic Data. \emph{Applied Spectroscopy}, 62(1), p. 91-106.
\doi{10.1366/000370208783412762}

Ryan, C. G., Clayton, E., Griffin, W. L., Sie, S. H. & Cousens, D. R.
(1988). SNIP, a statistics-sensitive background treatment for the
quantitative analysis of PIXE spectra in geoscience applications.
\emph{Nuclear Instruments and Methods in Physics Research Section B:
Beam Interactions with Materials and Atoms}, 34(3), p. 396-402.
\doi{10.1016/0168-583X(88)90063-8}
}
\seealso{
\code{\link[=signal_correct]{signal_correct()}}

Other baseline estimation methods: 
\code{\link{baseline_asls}()},
\code{\link{baseline_linear}()},
\code{\link{baseline_peakfilling}()},
\code{\link{baseline_polynomial}()},
\code{\link{baseline_rollingball}()},
\code{\link{baseline_rubberband}()}
}
\author{
N. Frerebeau
}
\concept{baseline estimation methods}
