% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alluvial.R
\name{alluvial}
\alias{alluvial}
\title{Alluvial diagram}
\usage{
alluvial(..., freq, col = "gray", border = 0, layer, hide = FALSE,
  alpha = 0.5, gap.width = 0.05, xw = 0.1, cw = 0.1, blocks = TRUE,
  ordering = NULL, axis_labels = NULL, cex = par("cex"),
  cex.axis = par("cex.axis"))
}
\arguments{
\item{...}{vectors or data frames, all for the same number of observations}

\item{freq}{numeric, vector of frequencies of the same length as the number of observations}

\item{col}{vector of colors of the stripes}

\item{border}{vector of border colors for the stripes}

\item{layer}{numeric, order of drawing of the stripes}

\item{hide}{logical, should particular stripe be plotted}

\item{alpha}{numeric, vector of transparency of the stripes}

\item{gap.width}{numeric, relative width of inter-category gaps}

\item{xw}{numeric, the distance from the set axis to the control points of the xspline}

\item{cw}{numeric, width of the category axis}

\item{blocks}{logical, whether to use blocks to tie the flows together at each category, versus contiguous ribbons (also admits character value "bookends")}

\item{ordering}{list of numeric vectors allowing to reorder the alluvia on each axis separately, see Examples}

\item{axis_labels}{character, labels of the axes, defaults to variable names in the data}

\item{cex, cex.axis}{numeric, scaling of fonts of category labels and axis labels respectively. See \code{\link{par}}.}
}
\value{
Invisibly a list with elements:
\item{endpoints}{A list of matrices of y-coordinates of endpoints of the
alluvia. x-coordinates are consecutive natural numbers.}
}
\description{
Drawing alluvial diagrams, also known as parallel set plots.
}
\note{
Please mind that the API is planned to change to be more compatible
  with \pkg{dplyr} verbs.
}
\examples{
# Titanic data
tit <- as.data.frame(Titanic)

# 2d
tit2d <- aggregate( Freq ~ Class + Survived, data=tit, sum)
alluvial( tit2d[,1:2], freq=tit2d$Freq, xw=0.0, alpha=0.8,
         gap.width=0.1, col= "steelblue", border="white",
         layer = tit2d$Survived != "Yes" )

alluvial( tit2d[,1:2], freq=tit2d$Freq, 
         hide=tit2d$Freq < 150,
         xw=0.0, alpha=0.8,
         gap.width=0.1, col= "steelblue", border="white",
         layer = tit2d$Survived != "Yes" )

# 3d
tit3d <- aggregate( Freq ~ Class + Sex + Survived, data=tit, sum)

alluvial(tit3d[,1:3], freq=tit3d$Freq, alpha=1, xw=0.2,
         col=ifelse( tit3d$Survived == "No", "red", "gray"),
         layer = tit3d$Sex != "Female",
         border="white")


# 4d
alluvial( tit[,1:4], freq=tit$Freq, border=NA,
         hide = tit$Freq < quantile(tit$Freq, .50),
         col=ifelse( tit$Class == "3rd" & tit$Sex == "Male", "red", "gray") )

# 3d example with custom ordering
# Reorder "Sex" axis according to survival status
ord <- list(NULL, with(tit3d, order(Sex, Survived)), NULL)
alluvial(tit3d[,1:3], freq=tit3d$Freq, alpha=1, xw=0.2,
         col=ifelse( tit3d$Survived == "No", "red", "gray"),
         layer = tit3d$Sex != "Female",
         border="white", ordering=ord)

# Possible blocks options
for (blocks in c(TRUE, FALSE, "bookends")) {
    
    # Elaborate alluvial diagram from main examples file
    alluvial( tit[, 1:4], freq = tit$Freq, border = NA,
              hide = tit$Freq < quantile(tit$Freq, .50),
              col = ifelse( tit$Class == "3rd" & tit$Sex == "Male",
                            "red", "gray" ),
              blocks = blocks )
}


# Data returned
x <- alluvial( tit2d[,1:2], freq=tit2d$Freq, xw=0.0, alpha=0.8,
          gap.width=0.1, col= "steelblue", border="white",
          layer = tit2d$Survived != "Yes" )
points( rep(1, 16), x$endpoints[[1]], col="green")
points( rep(2, 16), x$endpoints[[2]], col="blue")
}

