% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rschedule.R
\name{new_rschedule}
\alias{new_rschedule}
\alias{rschedule_events}
\title{Create a new rschedule}
\usage{
new_rschedule(..., class)

rschedule_events(x)
}
\arguments{
\item{...}{\verb{[named fields]}

Named data fields.}

\item{class}{\verb{[character]}

A required subclass.}

\item{x}{\verb{[rschedule subclass]}

An object that subclasses rschedule.}
}
\value{
For \code{new_rschedule()}, a new rschedule subclass.

For \code{rschedule_events()}, a Date vector of events.
}
\description{
\code{new_rschedule()} is a developer focused tool that is not required for
normal usage of almanac. It is only exported to allow other packages
to construct new rschedule objects that work with almanac functions
prefixed with \verb{alma_*()}, like \code{\link[=alma_in]{alma_in()}}.

\code{rschedule_events()} is a generic function that rschedule subclasses must
provide a method for. \code{rschedule_events()} should return a Date vector
containing the complete ordered set of events in the event set of
that rschedule.
}
\details{
An rschedule is an abstract class that rrule and rbundle both inherit from.
The sole functionality of rschedule classes is to provide a method for
\code{rschedule_events()}.
}
\examples{
events <- as.Date("1970-01-01")

static <- new_rschedule(
  events = events,
  class = "static_rschedule"
)

# You have to register an `rschedule_events()` method first!
try(alma_events(static))
}
