% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{loadouts}
\alias{loadouts}
\title{Loadouts}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{version}}{Country code for the version of the show}
  \item{\code{season}}{The season number}
  \item{\code{id}}{Survivalist ID}
  \item{\code{name}}{Name of the survivalist}
  \item{\code{item_number}}{Item number}
  \item{\code{item_detailed}}{Detailed loadout item description}
  \item{\code{item}}{Loadout item. Simplified for aggregation}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Alone_(TV_series)}
}
\usage{
loadouts
}
\description{
Information on each survivalists loadout of 10 items
}
\examples{
library(dplyr)
library(ggplot2)
library(forcats)

loadouts |>
  count(item) |>
  mutate(item = fct_reorder(item, n, max)) |>
  ggplot(aes(item, n)) +
  geom_col() +
  geom_text(aes(item, n + 3, label = n)) +
  coord_flip()
}
\keyword{datasets}
