% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{split_by}
\alias{split_by}
\alias{split_by.data.frame}
\title{Split Data into Train and Test Set}
\usage{
split_by(.data, ...)

\method{split_by}{data.frame}(.data, target, ratio = 0.7, seed = NULL, ...)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{...}{further arguments passed to or from other methods.}

\item{target}{unquoted expression or variable name. the name of the target variable}

\item{ratio}{numeric. the ratio of the train dataset. default is 0.7}

\item{seed}{random seed used for splitting}
}
\value{
An object of split_by.
}
\description{
The split_by() splits the data.frame or tbl_df into a train set and a test set.
}
\details{
The split_df class is created, which contains the split information and criteria to separate the training and the test set.
}
\section{attributes of split_by}{

The attributes of the split_df class are as follows.:

\itemize{
\item split_seed : integer. random seed used for splitting
\item target : character. the name of the target variable
\item binary : logical. whether the target variable is binary class
\item minority : character. the name of the minority class
\item majority : character. the name of the majority class
\item minority_rate : numeric. the rate of the minority class
\item majority_rate : numeric. the rate of the majority class
}
}

\examples{
library(dplyr)

# Credit Card Default Data
head(ISLR::Default)

# Generate data for the example
sb <- ISLR::Default \%>\%
  split_by(default)

sb

}
