% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aloom.R
\name{aloom}
\alias{aloom}
\title{All Leave-One-Out Models}
\usage{
aloom(train.x, train.y, test.x, method, model.params)
}
\arguments{
\item{train.x}{input matrix, of dimension nobs x nvars; each row is an observation
vector.}

\item{train.y}{response variable. Expected to be binary factor.}

\item{test.x}{Matrix of new values for \code{train.x} at which predictions are to be
made. Must be a matrix.}

\item{method}{name of the model. Currently allowed values are rf and glmnet}

\item{model.params}{list of model parameters}
}
\value{
A list containing predictedY, predictedProbabilityY and allPredictions
}
\description{
Creates a predictive model for a training set, as well as
all leave-one-out predictive models. Produces predictions of
all models (original and all leave one-out) for a test set.
}
\examples{

library(randomForest)
x1 <- matrix(rnorm(100 * 20), 100, 20)
x2 <- matrix(rnorm(30 * 20), 30, 20)
y1 <- as.factor(sample(c("POS","NEG"), 100, replace = TRUE))
model.params <- list(ntree=100)
fit <- aloom(x1,y1,x2,method="rf",model.params)

}
