% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feglmControl.R
\name{feglmControl}
\alias{feglmControl}
\alias{feglm.control}
\title{Set \code{feglm} Control Parameters}
\usage{
feglmControl(
  dev.tol = 1e-08,
  center.tol = 1e-05,
  iter.max = 25L,
  limit = 10L,
  trace = FALSE,
  drop.pc = TRUE,
  conv.tol = NULL,
  rho.tol = NULL,
  pseudo.tol = NULL,
  step.tol = NULL
)

feglm.control(...)
}
\arguments{
\item{dev.tol}{tolerance level for the first stopping condition of the maximization routine. The 
stopping condition is based on the relative change of the deviance in iteration \eqn{r}
and can be expressed as follows:
\eqn{|dev_{r} - dev_{r - 1}| / (0.1 + |dev_{r}|) < tol}{|dev - devold| / (0.1 + |dev|) < tol}.
Default is \code{1.0e-08}.}

\item{center.tol}{tolerance level for the stopping condition of the centering algorithm.
The stopping condition is based on the relative change of the euclidean norm. Default is \code{1.0e-05}.}

\item{iter.max}{unsigned integer indicating the maximum number of iterations in the maximization
routine. Default is \code{25L}.}

\item{limit}{unsigned integer indicating the maximum number of iterations of 
\code{\link[MASS]{theta.ml}}. Default is \code{10L}.}

\item{trace}{logical indicating if output should be produced in each iteration. Default is \code{FALSE}.}

\item{drop.pc}{logical indicating to drop observations that are perfectly classified/separated and hence 
do not contribute to the log-likelihood. This option is useful to reduce the computational costs of
the maximization problem and improves the numerical stability of the algorithm. Note that dropping
perfectly separated observations does not affect the estimates. Default is \code{TRUE}.}

\item{conv.tol, rho.tol}{deprecated; step-halving is now similar to \code{glm.fit2}.}

\item{pseudo.tol}{deprecated; use \code{center.tol} instead.}

\item{step.tol}{deprecated; termination conditions is now similar to \code{\link[stats]{glm}}.}

\item{...}{arguments passed to the deprecated function \code{\link{feglm.control}}.}
}
\value{
The function \code{\link{feglmControl}} returns a named list of control 
parameters.
}
\description{
Set and change parameters used for fitting \code{\link{feglm}}.

\strong{Note:} \code{\link{feglm.control}} is deprecated and will be removed soon.
}
\seealso{
\code{\link{feglm}}
}
