% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feglm.R
\name{feglmControl}
\alias{feglmControl}
\alias{feglm.control}
\title{Set \code{feglm} Control Parameters}
\usage{
feglmControl(dev.tol = 1e-08, center.tol = 1e-05, rho.tol = 1e-04,
  conv.tol = 1e-06, iter.max = 100L, limit = 10L, trace = FALSE,
  drop.pc = TRUE, pseudo.tol = NULL, step.tol = NULL)

feglm.control(...)
}
\arguments{
\item{dev.tol}{tolerance level for the first stopping condition of the maximization routine. The 
stopping condition is based on the relative change of the deviance in iteration \eqn{r}
and can be expressed as follows: \eqn{(dev_{r - 1} - dev_{r}) / (0.1 + dev_{r}) < 
tol}{\Delta dev / (0.1 + dev) < tol}. Default is \code{1.0e-08}.}

\item{center.tol}{tolerance level for the stopping condition of the centering algorithm.
The stopping condition is based on the relative change of euclidean norm in iteration \eqn{i} and
can be expressed as follows: \eqn{||\mathbf{v}_{i} - \mathbf{v}_{i - 1}||_{2} < 
tol ||\mathbf{v}_{i - 1}||}{||\Delta v|| / ||v_old|| < tol}. Default is
\code{1.0e-05}.}

\item{rho.tol}{tolerance level for the stephalving in the maximization routine. Stephalving only takes
place if the deviance in iteration \eqn{r} is larger than the one of the previous iteration. If 
this is the case, 
\eqn{||\boldsymbol{\beta}_{r} - \boldsymbol{\beta}_{r - 1}||_{2}}{||\Delta \beta||} is 
halfed until the deviance is less or numerically equal compared to the deviance of the previous
iteration. Stephalving fails if the the following condition holds: \eqn{\rho < tol}{\rho < tol}, 
where \eqn{\rho}{\rho} is the stepcorrection factor. If stephalving fails the maximization
routine is canceled. Default is \code{1.0e-04}.}

\item{conv.tol}{tolerance level that accounts for rounding errors inside the stephalving routine when
comparing the deviance with the one of the previous iteration. Default is \code{1.0e-06}.}

\item{iter.max}{unsigned integer indicating the maximum number of iterations in the maximization
routine. Default is \code{100L}.}

\item{limit}{unsigned integer indicating the maximum number of iterations of 
\code{\link[MASS]{theta.ml}}. Default is \code{10L}.}

\item{trace}{logical indicating if output should be produced in each iteration. Default is \code{FALSE}.}

\item{drop.pc}{logical indicating to drop observations that are perfectly classified 
(perfectly seperated) and hence do not contribute to the log-likelihood. This option is useful to
reduce the computational costs of the maximization problem, since it reduces the number of
observations and does not affect the estimates. Default is \code{TRUE}.}

\item{pseudo.tol}{deprecated; use \code{center.tol} instead.}

\item{step.tol}{depreacted; termination conditions is now similar to \code{\link[stats]{glm}}.}

\item{...}{arguments passed to the deprecated function \code{\link{feglmControl}}.}
}
\value{
The function \code{\link{feglmControl}} returns a named list of control 
parameters.
}
\description{
Set and change parameters used for fitting \code{\link{feglm}}.

\strong{Note:} \code{\link{feglm.control}} is deprecated and will be removed soon.
}
\seealso{
\code{\link{feglm}}
}
