% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LQRFE_main_v2.R
\name{mqr}
\alias{mqr}
\title{multiple penalized quantile regression}
\usage{
mqr(x, y, subj, tau = 1:9/10, method = "qr", ngrid = 20, inf = 1e-08, digt = 4)
}
\arguments{
\item{x}{Numeric matrix, covariates}

\item{y}{Numeric vector, outcome.}

\item{subj}{Numeric vector, identifies the unit to which the observation belongs.}

\item{tau}{Numeric vector, identifies the percentiles.}

\item{method}{Factor, "qr" quantile regression, "qrfe" quantile regression with fixed effects, "lqrfe" Lasso quantile regression with fixed effects, "alqr" adaptive Lasso quantile regression with fixed effects.}

\item{ngrid}{Numeric scalar greater than one, number of BIC to test.}

\item{inf}{Numeric scalar, internal value, small value.}

\item{digt}{Numeric scalar, internal value greater than one, define "zero" coefficient.}
}
\value{
Beta Numeric array, with three dimmensions: 1) tau, 2) coef., lower bound, upper bound, 3) exploratory variables.
}
\description{
Estimate QR for several taus
}
\examples{
n = 10
m = 5
d = 4
N = n*m
L = N*d
x = matrix(rnorm(L), ncol=d, nrow=N)
subj = rep(1:n, each=m)
alpha = rnorm(n)
beta = rnorm(d)
eps = rnorm(N)
y = x \%*\% beta  + matrix(rep(alpha, each=m) + eps)
y = as.vector(y)

Beta = mqr(x,y,subj,tau=1:9/10, method="qr", ngrid = 10)
Beta

}
