% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{running_jobs}
\alias{running_jobs}
\alias{queue_job}
\alias{build_answers}
\alias{queue_job}
\alias{build_answers}
\title{Queue Job for an App}
\usage{
queue_job(app, answers, track_job = FALSE, sleep = 10, timeout = 3600,
  gallery = getOption("alteryx_gallery"))

build_answers(name_value, ...)
}
\arguments{
\item{app}{A single \code{alteryx_app} returned from \code{get_app}}

\item{answers}{Answers to required \code{app} questions created using
\code{build_answers}}

\item{track_job}{If \code{TRUE} this function will not return a value until
the job completes on Alteryx Gallery}

\item{sleep}{Amount of time to wait between job polls. Ignored if
\code{track_job = FALSE}}

\item{timeout}{Maximum amount of time to track job. Ignored if
\code{track_job = FALSE}}

\item{gallery}{URL for your Alteryx Gallery}

\item{name_value}{\code{list} containing an app question name and value pair}

\item{...}{Additional \code{name_value} pairs}
}
\value{
An alteryx job with status "Queued"
}
\description{
Each app has a set of questions that require an answer in order
to be run. The answers to the app questions are formatted using
\code{build_answers}. To see the required questions for an app use
\code{get_app_questions}.

Use \code{queue_job} to queue a job for an app. A job is a single run
of an app run according to the answers submitted.
}
\section{See Also}{

Use \code{get_app} to find apps to queue.

Once a job has been queued, use \code{get_job} to poll the job and
check its status.
}

\examples{
\dontrun{
first_question <- list(name = "a", value = "1")
second_question <- list(name = "b", value = "2")
answers <- build_answers(first_question, second_question)

new_job <- queue_job(app, answers)
}

}
