% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calculate_tri}
\alias{calculate_tri}
\title{Calculate toxic release covariates}
\usage{
calculate_tri(
  from = NULL,
  locs,
  locs_id = "site_id",
  radius = c(1000L, 10000L, 50000L),
  geom = FALSE,
  ...
)
}
\arguments{
\item{from}{SpatVector(1). Output of \code{process_tri()}.}

\item{locs}{sf/SpatVector. Locations where TRI variables are calculated.}

\item{locs_id}{character(1). Unique site identifier column name.
Default is \code{"site_id"}.}

\item{radius}{Circular buffer radius.
Default is \code{c(1000, 10000, 50000)} (meters)}

\item{geom}{FALSE/"sf"/"terra".. Should the function return with geometry?
Default is \code{FALSE}, options with geometry are "sf" or "terra". The
coordinate reference system of the \code{sf} or \code{SpatVector} is that of \code{from.}}

\item{...}{Placeholders.}
}
\value{
a data.frame or SpatVector object
}
\description{
Extract toxic release values at point locations. Returns a \code{data.frame}
object containing \code{locs_id} and variables for each chemical in
\code{from}.
}
\note{
U.S. context.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calculate_tri(
  from = tri, # derived from process_tri() example
  locs = loc,
  locs_id = "id",
  radius = c(1e3L, 1e4L, 5e4L)
)
}
}
\seealso{
\code{\link{sum_edc}}, \code{\link{process_tri}}
}
\author{
Insang Song, Mariana Kassien
}
