% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoord.R
\name{extractCoord}
\alias{extractCoord}
\title{Extract coordinate from a geocoding response}
\usage{
extractCoord(res)
}
\arguments{
\item{res}{Required.
Response object returned by [getCoord()] with `output = "JSON"` or by the
AutoNavi geocoding API.}
}
\value{
A `tibble` with one row per geocode candidate. The table contains the
original columns provided by the API alongside a `match_rank` column that
indicates the ordering reported by AutoNavi. When the response does not
contain any matches a single placeholder row filled with `NA` values is
returned.
}
\description{
Extract coordinate from a geocoding response
}
\examples{
\dontrun{
raw <- getCoord("IFS Chengdu", output = "JSON")
extractCoord(raw)
}

}
\seealso{
[getCoord()]
}
