% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{amf_variables}
\alias{amf_variables}
\title{Get FP (Flux-Processing) Standard Variable List}
\usage{
amf_variables()
}
\value{
A data frame containing the following columns:
\itemize{
  \item Name - Standard variable name
  \item Description - Description of the variable
  \item Units - Standard variable unit
  \item Min - Expected minimal value
  \item Max - Expected maximal value
  }
}
\description{
This function obtains the latest AmeriFlux FP (Flux-Processing)
standard variable list. FP standard defines the variable names and units used
for continuously sampled data within the AmeriFlux. Also see AmeriFlux Data
Variables page \url{https://ameriflux.lbl.gov/data/aboutdata/data-variables/}
for details.
}
\examples{
\dontrun{
# download the list of standard variable names and units
FP_ls <- amf_variables()
}
}
