% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/site_fidelity.R
\name{site_fidelity}
\alias{site_fidelity}
\alias{site_fidelity.steps_xy}
\title{Test for site fidelity of animal movement.}
\usage{
site_fidelity(x, ...)

\method{site_fidelity}{steps_xy}(x, n = 100, alpha = 0.05, ...)
}
\arguments{
\item{x}{A track}

\item{...}{None implemented}

\item{n}{Numeric scalar. The number of simulated trajectories.}

\item{alpha}{Numeric scalar. The alpha value used for the bootstrapping.}
}
\value{
A list of length 4. \code{msd_dat} and \code{li_dat} is the mean square distance and linearity for the real date. \code{msd_sim} and `li_sim`` are the mean square distances and linearities for the simulated trajectories.
}
\description{
Calculates two indices (mean squared displacement and linearity) to test for site fidelity. Significance testing is done by permuting step lengths and drawing turning angles from a uniform distribution.
}
\examples{
# real data
\dontrun{
data(deer)
ds <- deer \%>\% steps_by_burst()
site_fidelity(ds)
}
}
\references{
Spencer, S. R., Cameron, G. N., & Swihart, R. K. (1990). Operationally defining home range: temporal dependence exhibited by hispid cotton rats. Ecology, 1817-1822.
}
