% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaces.R
\name{as.space}
\alias{as.space}
\alias{spaces}
\alias{spaces_GET}
\alias{spaces}
\alias{space_create}
\title{Spaces storage operations}
\usage{
as.space(x)

spaces_GET(spaces_key = NULL, spaces_secret = NULL, ...)

spaces(spaces_key = NULL, spaces_secret = NULL, ...)

space_create(name, spaces_key = NULL, spaces_secret = NULL, ...)
}
\arguments{
\item{x}{Object to coerce to a space}

\item{spaces_key}{(character) String containing a spaces access key. If
missing, defaults to value stored in an environment variable
\code{DO_SPACES_ACCESS_KEY}.}

\item{spaces_secret}{(character) String containing the secret associated
with the spaces key. If missing, defaults to value stored in an environment
variable \code{DO_SPACES_SECRET_KEY}.}

\item{...}{Additional arguments passed down to \code{\link[aws.s3]{bucketlist}},
\code{\link[aws.s3]{get_bucket}}, \code{\link[aws.s3]{put_bucket}} functions
from the \code{aws.s3} package.}

\item{name}{(character) Space name.}
}
\description{
\describe{
 \item{spaces}{Retrieve all spaces in your digital ocean account}
 \item{space_create}{Create a new space}
}

Create a new space
}
\examples{
\dontrun{
# list spaces
spaces()

# obtain spaces as a list of space objects
res <- spaces()

# print space summary using a space object
summary(res[['my_space_name']])

# create a new space
space_create('new_space_name')
}
}
\keyword{internal}
