% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaces.R
\name{space_delete}
\alias{space_delete}
\title{Delete an existing Space}
\usage{
space_delete(
  name,
  spaces_region = NULL,
  spaces_key = NULL,
  spaces_secret = NULL,
  ...
)
}
\arguments{
\item{name}{(character) The name of the existing Space}

\item{spaces_region}{(character) String containing a spaces region. If
missing, defaults to value stored in an environment variable
\code{DO_SPACES_REGION}.}

\item{spaces_key}{(character) String containing a spaces access key. If
missing, defaults to value stored in an environment variable
\code{DO_SPACES_ACCESS_KEY}.}

\item{spaces_secret}{(character) String containing the secret associated
with the spaces key. If missing, defaults to value stored in an environment
variable \code{DO_SPACES_SECRET_KEY}.}

\item{...}{Additional arguments to \code{aws.s3::delete_bucket}}
}
\value{
(character) The name of the deleted Space.
}
\description{
Delete an existing Space
}
\examples{
\dontrun{
# Delete an existing Space
# (Check names within region)
space_delete("new_space_name")
}
}
