% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R
\name{registerFunction}
\alias{registerFunction}
\title{Register a user-defined function to be used with a \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object}
\usage{
registerFunction(functionName, heading = "", functionType = "batch",
  engine = "r",
  exceptionFunction = as.character(substitute(genericPipelineException)),
  isDataFunction = T, firstArgClass = "", loadPipeline = F,
  userDefined = T)
}
\arguments{
\item{functionName}{name of function to be registered}

\item{heading}{heading of that section in report}

\item{functionType}{type of function - 'batch' for \code{AnalysisPipeline} objects, 'streaming' for \code{StreamingAnalysisPipeline} objects}

\item{engine}{specifies which engine the function is to be run on. Available engines include "r", "spark", and "python"}

\item{exceptionFunction}{R object corresponding to the exception function}

\item{isDataFunction}{logical parameter which defines whether the function to be registered operates on data i.e. the first parameter is a dataframe}

\item{firstArgClass}{character string with the class of the first argument to the function, if it is a non-data function}

\item{loadPipeline}{logical parameter to see if function is being used in loadPipeline or not. This is for internal working}

\item{userDefined}{logical parameter defining whether the function is user defined. By default, set to true}
}
\description{
Register a user-defined function to be used with a \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object
}
\details{
The specified operation along with the heading and engine details is stored in the registry, after which it can be added to a pipeline.

If the function already exists in the registry, registration will be skipped. In order to change the definition, the function needs
to be reassigned in the Global Environment and then the \code{registerFunction} called again.
}
\examples{
\dontrun{
  library(analysisPipelines)
  getNumRows <- function(dataset){
   return(nrow(dataset))
  }

  registerFunction("getNumRows")
}
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
