% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R
\docType{class}
\name{BaseAnalysisPipeline-class}
\alias{BaseAnalysisPipeline-class}
\alias{BaseAnalysisPipeline}
\title{Base class for \code{AnalysisPipeline} and \code{StreamingAnalysisPipeline} objects}
\description{
Base class for \code{AnalysisPipeline} and \code{StreamingAnalysisPipeline} objects
}
\details{
The class which holds the metadata including the registry of available functions,
the data on which the pipeline is to be applied, as well as the pipeline itself, and serves
as the base class for various types of Pipeline objects such as Batch and Streaming.

This base class which contains the slots related to the registry, pipeline and output can be extended
to create custom class for specific scenarios if required.

In the documentation, objects of classes which are subclasses of this class are referred to as 'Pipeline' objects
}
\section{Slots}{

\describe{
\item{\code{pipeline}}{A tibble which holds functions to be called}

\item{\code{pipelineExecutor}}{A list containing details of the execution, such as topological ordering of functions to be executed,
dependency map of functions, as well as logger configuration}

\item{\code{output}}{A list which holds all the functions output}
}}

\seealso{
Other Package core functions: \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
