## Function: ghweights()
##
## Author:   Jonathan Wand (jwand@latte.harvard.edu)
##
## Created :  2002-10-05
## Modified:  $Date: 2005/08/10 19:06:50 $
## Revision:  $Revision: 1.1 $
## RCS-ID:    $Id: ghweights.R,v 1.1 2005/08/10 19:06:50 jwand Exp $
##
## INPUT:
##   neval: how many cutpoints at which for quadrature
##
## OUTPUT:
##    x: nodes,
##    w: weights
##
## BACKGROUND: 
##   Data based on hermite.dec - Hermite Quadrature
##
##   "If you want to add new matrixes to this file, use the GHERM function
##   to calculate the new weights and nodes."
##  
##   Written for gauss by:
##                Anita Gulyasne Goldpergel.
##                CBRSS, Harvard University,
##                anitag@latte.harvard.edu
##  
##
ghweights <- function(neval=16) {
  neval <- as.character(neval)
  
  hi <- switch(neval,
               "2" = matrix( c(
                 -7.071067811865476e-1 ,  8.86226925452758e-1,
                 7.071067811865476e-1  ,  8.86226925452758e-1),
                 ncol=2,byrow=TRUE),
               "4" = matrix( c(
                 -1.650680123885785e0  ,  8.13128354472452e-2,
                 -5.246476232752904e-1 ,  8.04914090005513e-1,
                 5.246476232752904e-1  ,  8.04914090005513e-1,
                 1.650680123885785e0   ,  8.13128354472452e-2),
                 ncol=2,byrow=TRUE),
               "8" = matrix( c(
                 -2.930637420257244e0  ,  1.996040722113676e-4,
                 -1.981656756695843e0  ,  1.707798300741347e-2,
                 -1.15719371244678e0   ,  2.078023258148919e-1,
                 -3.811869902073221e-1 ,  6.611470125582414e-1,
                 3.811869902073221e-1  ,  6.611470125582414e-1,
                 1.15719371244678e0    ,  2.078023258148919e-1,
                 1.981656756695843e0   ,  1.707798300741347e-2,
                 2.930637420257244e0   ,  1.996040722113676e-4),
                   ncol=2,byrow=TRUE),
               "16" = matrix( c(
                 -4.688738939305818e0 ,   2.654807474011183e-10,
                 -3.869447904860123e0 ,   2.320980844865211e-7,
                 -3.176999161979956e0 ,   2.711860092537881e-5,
                 -2.546202157847481e0 ,   9.32284008624181e-4,
                 -1.951787990916254e0 ,   1.288031153550997e-2,
                 -1.380258539198881e0 ,   8.38100413989858e-2,
                 -8.22951449144656e-1 ,   2.806474585285337e-1,
                 -2.734810461381524e-1,   5.079294790166138e-1,
                 2.734810461381524e-1 ,   5.079294790166138e-1,
                 8.22951449144656e-1  ,   2.806474585285337e-1,
                 1.380258539198881e0  ,   8.38100413989858e-2,
                 1.951787990916254e0  ,   1.288031153550997e-2,
                 2.546202157847481e0  ,   9.32284008624181e-4,
                 3.176999161979956e0  ,   2.711860092537881e-5,
                 3.869447904860123e0  ,   2.320980844865211e-7,
                 4.688738939305818e0  ,   2.654807474011183e-10),
                 ncol=2,byrow=TRUE),
               "32" = matrix( c(
                 -7.125813909830728e0   , 7.310676427384165e-23,
                 -6.409498149269661e0   , 9.23173653651829e-19,
                 -5.812225949515914e0   , 1.197344017092849e-15,
                 -5.275550986515881e0   , 4.215010211326448e-13,
                 -4.777164503502596e0   , 5.933291463396639e-11,
                 -4.305547953351199e0   , 4.098832164770897e-9,
                 -3.853755485471445e0   , 1.574167792545594e-7,
                 -3.417167492818571e0   , 3.650585129562376e-6,
                 -2.992490825002374e0   , 5.416584061819983e-5,
                 -2.577249537732317e0   , 5.36268365527972e-4,
                 -2.169499183606112e0   , 3.654890326654428e-3,
                 -1.767654109463201e0   , 1.755342883157343e-2,
                 -1.370376410952872e0   , 6.045813095591262e-2,
                 -9.76500463589683e-1   , 1.512697340766425e-1,
                 -5.849787654359325e-1  , 2.774581423025299e-1,
                 -1.948407415693993e-1  , 3.752383525928024e-1,
                 1.948407415693993e-1   , 3.752383525928024e-1,
                 5.849787654359325e-1   , 2.774581423025299e-1,
                 9.76500463589683e-1    , 1.512697340766425e-1,
                 1.370376410952872e0    , 6.045813095591262e-2,
                 1.767654109463201e0    , 1.755342883157343e-2,
                 2.169499183606112e0    , 3.654890326654428e-3,
                 2.577249537732317e0    , 5.36268365527972e-4,
                 2.992490825002374e0    , 5.416584061819983e-5,
                 3.417167492818571e0    , 3.650585129562376e-6,
                 3.853755485471445e0    , 1.574167792545594e-7,
                 4.305547953351199e0    , 4.098832164770897e-9,
                 4.777164503502596e0    , 5.933291463396639e-11,
                 5.275550986515881e0    , 4.215010211326448e-13,
                 5.812225949515914e0    , 1.197344017092849e-15,
                 6.409498149269661e0    , 9.23173653651829e-19,
                 7.125813909830728e0    , 7.310676427384165e-23),
                 ncol=2,byrow=TRUE),
               "64" = matrix( c(
                 -1.052612316796055e1   , 5.535706535856943e-49,
                 -9.89528758682954e0    , 1.67974799010816e-43,
                 -9.37315954964672e0    , 3.421138011255741e-39,
                 -8.90724909996477e0    , 1.557390624629764e-35,
                 -8.47752908337986e0    , 2.549660899113e-32,
                 -8.07368728501023e0    , 1.929103595464967e-29,
                 -7.689540164040497e0   , 7.861797788925911e-27,
                 -7.32101303278095e0    , 1.911706883300643e-24,
                 -6.965241120551108e0   , 2.982862784279851e-22,
                 -6.620112262636028e0   , 3.152254566503782e-20,
                 -6.284011228774828e0   , 2.351884710675819e-18,
                 -5.955666326799486e0   , 1.280093391322438e-16,
                 -5.634052164349973e0   , 5.218623726590847e-15,
                 -5.318325224633271e0   , 1.628340730709721e-13,
                 -5.007779602198769e0   , 3.959177766947724e-12,
                 -4.7018156474075e0     , 7.615217250145451e-11,
                 -4.399917168228138e0   , 1.173616742321549e-9,
                 -4.101634474566657e0   , 1.465125316476109e-8,
                 -3.80657151394536e0    , 1.495532936727247e-7,
                 -3.514375935740906e0   , 1.258340251031185e-6,
                 -3.224731291992036e0   , 8.78849923085036e-6,
                 -2.937350823004622e0   , 5.125929135786274e-5,
                 -2.651972435430635e0   , 2.509836985130625e-4,
                 -2.368354588632402e0   , 1.036329099507578e-3,
                 -2.086272879881762e0   , 3.622586978534459e-3,
                 -1.805517171465545e0   , 1.075604050987914e-2,
                 -1.525889140209863e0   , 2.720312895368892e-2,
                 -1.247200156943118e0   , 5.873998196409943e-2,
                 -9.69269423071178e-1   , 1.084983493061868e-1,
                 -6.919223058100446e-1  , 1.716858423490837e-1,
                 -4.149888241210788e-1  , 2.32994786062678e-1,
                 -1.383022449870097e-1  , 2.71377424941304e-1,
                 1.383022449870097e-1   , 2.71377424941304e-1,
                 4.149888241210788e-1   , 2.32994786062678e-1,
                 6.919223058100446e-1   , 1.716858423490837e-1,
                 9.69269423071178e-1    , 1.084983493061868e-1,
                 1.247200156943118e0    , 5.873998196409943e-2,
                 1.525889140209863e0    , 2.720312895368892e-2,
                 1.805517171465545e0    , 1.075604050987914e-2,
                 2.086272879881762e0    , 3.622586978534459e-3,
                 2.368354588632402e0    , 1.036329099507578e-3,
                 2.651972435430635e0    , 2.509836985130625e-4,
                 2.937350823004622e0    , 5.125929135786274e-5,
                 3.224731291992036e0    , 8.78849923085036e-6,
                 3.514375935740906e0    , 1.258340251031185e-6,
                 3.80657151394536e0     , 1.495532936727247e-7,
                 4.101634474566657e0    , 1.465125316476109e-8,
                 4.399917168228138e0    , 1.173616742321549e-9,
                 4.7018156474075e0      , 7.615217250145451e-11,
                 5.007779602198769e0    , 3.959177766947724e-12,
                 5.318325224633271e0    , 1.628340730709721e-13,
                 5.634052164349973e0    , 5.218623726590847e-15,
                 5.955666326799486e0    , 1.280093391322438e-16,
                 6.284011228774828e0    , 2.351884710675819e-18,
                 6.620112262636028e0    , 3.152254566503782e-20,
                 6.965241120551108e0    , 2.982862784279851e-22,
                 7.32101303278095e0     , 1.911706883300643e-24,
                 7.689540164040497e0    , 7.861797788925911e-27,
                 8.07368728501023e0     , 1.929103595464967e-29,
                 8.47752908337986e0     , 2.549660899113e-32,
                 8.90724909996477e0     , 1.557390624629764e-35,
                 9.37315954964672e0     , 3.421138011255741e-39,
                 9.89528758682954e0     , 1.67974799010816e-43,
                 1.052612316796055e1    , 5.535706535856943e-49),
                 ncol=2,byrow=TRUE),
               "128" = matrix( c(
                 -1.529181976688274e1   , 1.799065980109285e-102,
                 -1.47338424735893e1    , 2.608172402409111e-95,
                 -1.427398130478783e1   , 1.404689771315089e-89,
                 -1.386520698447624e1   , 1.261249483338538e-84,
                 -1.348955641262314e1   , 3.401230086936636e-80,
                 -1.313777478802765e1   , 3.751215868804724e-76,
                 -1.280431208206713e1   , 2.041585797243985e-72,
                 -1.248551258534945e1   , 6.214244161830314e-69,
                 -1.217880861983124e1   , 1.156155164096375e-65,
                 -1.188231011887831e1   , 1.404467257740487e-62,
                 -1.159457505474145e1   , 1.17197850121298e-59,
                 -1.131447164428998e1   , 6.993072924051958e-57,
                 -1.104109097601963e1   , 3.082077383339299e-54,
                 -1.077368911516144e1   , 1.030486252055695e-51,
                 -1.051164732991487e1   , 2.672743751736068e-49,
                 -1.025444392847093e1   , 5.480217028978797e-47,
                 -1.000163379893012e1   , 9.02804013878664e-45,
                 -9.75283321343917e0    , 1.211779534130592e-42,
                 -9.50770832327906e0    , 1.341497481764369e-40,
                 -9.26596630029618e0    , 1.238085557976368e-38,
                 -9.02734841339479e0    , 9.6167080679675e-37,
                 -8.79162454488869e0    , 6.339913526366491e-35,
                 -8.55858879506451e0    , 3.574378895879421e-33,
                 -8.32805592079015e0    , 1.735103020282061e-31,
                 -8.0998584215079e0     , 7.296545006768406e-30,
                 -7.873844133535435e0   , 2.672923620058073e-28,
                 -7.649874227681007e0   , 8.57283048376936e-27,
                 -7.427821529952302e0   , 2.418403459647665e-25,
                 -7.207569103387334e0   , 6.025984032006456e-24,
                 -6.989009042644775e0   , 1.33136785903359e-22,
                 -6.772041443255929e0   , 2.617457583934811e-21,
                 -6.556573515264483e0   , 4.594007677329723e-20,
                 -6.34251881700178e0    , 7.220107316928292e-19,
                 -6.129796589422163e0   , 1.018933230423292e-17,
                 -5.918331175085812e0   , 1.294548159339371e-16,
                 -5.708051508768087e0   , 1.484223837513856e-15,
                 -5.49889066897391e0    , 1.539049730353545e-14,
                 -5.29078548147718e0    , 1.446347321190417e-13,
                 -5.083676167489341e0   , 1.234214486600556e-12,
                 -4.877506030264814e0   , 9.58031650873586e-12,
                 -4.672221174932639e0   , 6.775780487774555e-11,
                 -4.467770257148584e0   , 4.373186659848404e-10,
                 -4.264104256825519e0   , 2.579397229426394e-9,
                 -4.061176273749273e0   , 1.392190715293518e-8,
                 -3.858941342344282e0   , 6.88458112215435e-8,
                 -3.657356263235308e0   , 3.122872986178903e-7,
                 -3.456379449571737e0   , 1.300747003238199e-6,
                 -3.255970786350659e0   , 4.979924532590987e-6,
                 -3.05609150120268e0    , 1.75404858480939e-5,
                 -2.856704045297405e0   , 5.688743760040243e-5,
                 -2.657771983189484e0   , 1.700140882628094e-4,
                 -2.459259890565739e0   , 4.685515378084114e-4,
                 -2.261133258973062e0   , 1.191563814457167e-3,
                 -2.063358406708566e0   , 2.79783940160579e-3,
                 -1.865902395140599e0   , 6.068862406925888e-3,
                 -1.668732949803723e0   , 1.216691886446934e-2,
                 -1.471818385674486e0   , 2.255431016782442e-2,
                 -1.275127536089158e0   , 3.867395481063691e-2,
                 -1.078629684810909e0   , 6.136072100449007e-2,
                 -8.82294500792981e-1   , 9.01086783764489e-2,
                 -6.860919752173349e-1  , 1.225032731641357e-1,
                 -4.899923604154589e-1  , 1.542104352983544e-1,
                 -2.939661103002957e-1  , 1.797730839077993e-1,
                 -9.7983821955819e-2    , 1.940976118640877e-1,
                 9.7983821955819e-2     , 1.940976118640877e-1,
                 2.939661103002957e-1   , 1.797730839077993e-1,
                 4.899923604154589e-1   , 1.542104352983544e-1,
                 6.860919752173349e-1   , 1.225032731641357e-1,
                 8.82294500792981e-1    , 9.01086783764489e-2,
                 1.078629684810909e0    , 6.136072100449007e-2,
                 1.275127536089158e0    , 3.867395481063691e-2,
                 1.471818385674486e0    , 2.255431016782442e-2,
                 1.668732949803723e0    , 1.216691886446934e-2,
                 1.865902395140599e0    , 6.068862406925888e-3,
                 2.063358406708566e0    , 2.79783940160579e-3,
                 2.261133258973062e0    , 1.191563814457167e-3,
                 2.459259890565739e0    , 4.685515378084114e-4,
                 2.657771983189484e0    , 1.700140882628094e-4,
                 2.856704045297405e0    , 5.688743760040243e-5,
                 3.05609150120268e0     , 1.75404858480939e-5,
                 3.255970786350659e0    , 4.979924532590987e-6,
                 3.456379449571737e0    , 1.300747003238199e-6,
                 3.657356263235308e0    , 3.122872986178903e-7,
                 3.858941342344282e0    , 6.88458112215435e-8,
                 4.061176273749273e0    , 1.392190715293518e-8,
                 4.264104256825519e0    , 2.579397229426394e-9,
                 4.467770257148584e0    , 4.373186659848404e-10,
                 4.672221174932639e0    , 6.775780487774555e-11,
                 4.877506030264814e0    , 9.58031650873586e-12,
                 5.083676167489341e0    , 1.234214486600556e-12,
                 5.29078548147718e0     , 1.446347321190417e-13,
                 5.49889066897391e0     , 1.539049730353545e-14,
                 5.708051508768087e0    , 1.484223837513856e-15,
                 5.918331175085812e0    , 1.294548159339371e-16,
                 6.129796589422163e0    , 1.018933230423292e-17,
                 6.34251881700178e0     , 7.220107316928292e-19,
                 6.556573515264483e0    , 4.594007677329723e-20,
                 6.772041443255929e0    , 2.617457583934811e-21,
                 6.989009042644775e0    , 1.33136785903359e-22,
                 7.207569103387334e0    , 6.025984032006456e-24,
                 7.427821529952302e0    , 2.418403459647665e-25,
                 7.649874227681007e0    , 8.57283048376936e-27,
                 7.873844133535435e0    , 2.672923620058073e-28,
                 8.0998584215079e0      , 7.296545006768406e-30,
                 8.32805592079015e0     , 1.735103020282061e-31,
                 8.55858879506451e0     , 3.574378895879421e-33,
                 8.79162454488869e0     , 6.339913526366491e-35,
                 9.02734841339479e0     , 9.6167080679675e-37,
                 9.26596630029618e0     , 1.238085557976368e-38,
                 9.50770832327906e0     , 1.341497481764369e-40,
                 9.75283321343917e0     , 1.211779534130592e-42,
                 1.000163379893012e1    , 9.02804013878664e-45,
                 1.025444392847093e1    , 5.480217028978797e-47,
                 1.051164732991487e1    , 2.672743751736068e-49,
                 1.077368911516144e1    , 1.030486252055695e-51,
                 1.104109097601963e1    , 3.082077383339299e-54,
                 1.131447164428998e1    , 6.993072924051958e-57,
                 1.159457505474145e1    , 1.17197850121298e-59,
                 1.188231011887831e1    , 1.404467257740487e-62,
                 1.217880861983124e1    , 1.156155164096375e-65,
                 1.248551258534945e1    , 6.214244161830314e-69,
                 1.280431208206713e1    , 2.041585797243985e-72,
                 1.313777478802765e1    , 3.751215868804724e-76,
                 1.348955641262314e1    , 3.401230086936636e-80,
                 1.386520698447624e1    , 1.261249483338538e-84,
                 1.427398130478783e1    , 1.404689771315089e-89,
                 1.47338424735893e1     , 2.608172402409111e-95,
                 1.529181976688274e1    , 1.799065980109285e-102),
                 ncol=2,byrow=TRUE)
             );

  hi <- as.data.frame(hi)
  colnames(hi) <- c("x","w")
  return(hi)
}




