% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Normalization}
\usage{
normalize(ar, type = 1)
}
\arguments{
\item{ar}{numeric variable.}

\item{type}{integer: type of normalization (default: \code{1})}
}
\value{
Returns normalized variable.
}
\description{
Normalization of a variable:
\itemize{
\item \code{type==1}: \code{ar} normalized into \eqn{[0,1]},
\item \code{type==2}: \code{ar} is standardized,
\item otherwise no normalization is done.
}
}
\details{
Normalization of variable: \code{ar<-(ar-min(ar))/(max(ar)-min(ar))}
}
\examples{
normalize(iris[,1])
}
\author{
Jaroslav Myslivec \href{mailto:jaroslav.myslivec@upce.cz}{jaroslav.myslivec@upce.cz}, Sigbert Klinke \href{mailto:sigbert@hu-berlin.de}{sigbert@hu-berlin.de}
}
