% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim.plots.R
\name{anim.plot}
\alias{anim.plot}
\alias{anim.points}
\alias{anim.lines}
\alias{anim.text}
\alias{anim.plot.default}
\alias{anim.plot.formula}
\alias{anim.points.default}
\alias{anim.lines.default}
\alias{anim.text.default}
\alias{anim.symbols}
\alias{anim.points.formula}
\alias{anim.lines.formula}
\alias{anim.text.formula}
\title{Create an animated plot.}
\usage{
anim.plot(...)

anim.points(...)

anim.lines(...)

anim.text(...)

\method{anim.plot}{default}(
  x,
  y = NULL,
  times = 1:length(x),
  speed = 1,
  show = TRUE,
  use.times = TRUE,
  window = if (identical(fn, lines)) t:(t + 1) else t,
  window.process = NULL,
  xlim = NULL,
  ylim = NULL,
  col = par("col"),
  xaxp = NULL,
  yaxp = NULL,
  pch = par("pch"),
  cex = 1,
  labels = NULL,
  asp = NULL,
  lty = par("lty"),
  lwd = par("lwd"),
  fn = plot,
  ...
)

\method{anim.plot}{formula}(
  formula,
  data = parent.frame(),
  subset = NULL,
  fn = plot,
  window = t,
  ...
)

\method{anim.points}{default}(...)

\method{anim.lines}{default}(...)

\method{anim.text}{default}(...)

anim.symbols(...)

\method{anim.points}{formula}(formula, ...)

\method{anim.lines}{formula}(formula, ...)

\method{anim.text}{formula}(formula, ...)
}
\arguments{
\item{x, y}{vectors of x and y coordinates. These can be passed in any way 
accepted by \code{\link{xy.coords}}.}

\item{times}{a vector of times. If \code{times} is length one, there will
be that many frames, equally divided over the length of \code{x} and \code{y}.}

\item{speed}{animation speed.}

\item{show}{if false, do not show plot; just return calls.}

\item{use.times}{if \code{TRUE}, animation speed is determined by the 
\code{times} argument. If \code{FALSE}, animation speed is constant.}

\item{window}{what window of times to show in each animation. The default,
\code{t}, shows just plots from time t. To draw a plot incrementally,
use \code{window=1:t}.}

\item{window.process}{function to call on each window of each times. See details.}

\item{xlim, ylim, col, pch}{arguments passed to \code{\link{plot}}.}

\item{labels, cex, lty, lwd}{as above.}

\item{asp, xaxp, yaxp, ...}{as above.}

\item{fn}{function called to create each frame.}

\item{formula}{a \code{\link{formula}} of the form \code{y ~ x + time}.}

\item{data}{a data frame from where the values in \code{formula} should be 
taken.}

\item{subset}{a vector specifying which rows of \code{data} to use.}
}
\description{
\code{anim.plot}
}
\details{
Each unique level of \code{times} will generate a single frame of animation. 
The frames will be ordered by \code{times}.

In general:

\itemize{ 
\item Parameters that apply to each point of the plot, such as 
\code{xlim, ylim, col, pch, labels} and \code{cex}, can be passed as vectors 
which will be recycled to \code{length(times)}. 
\item Parameters that apply
to the plot as a whole, and always have length 1, such as \code{xlab} and
\code{main}, can be passed as vectors and will be recycled to the number of
frames. 
\item Parameters that apply to the plot as a whole, and can have
length > 1, such as \code{xlim} and \code{ylim}, can be passed as vectors or
matrices. If vectors, the same vector will be passed to every frame. If
matrices, column \code{i} will be passed to the \code{i}'th frame. 
}

\code{window.process} should be a function which takes
two arguments: a list of potential arguments for the underlying
call to \code{plot}, and a vector of times. The function should return
the list of arguments after modification. This allows e.g. drawing 
"trails" of plot points. See the example
}
\examples{
x <- rep(1:100/10, 10)
times <- rep(1:10, each=100)
y <- sin(x*times/4)
anim.plot(x,y,times, type="l", col="orange", lwd=2)

## changing colours - a per-point parameter
anim.plot(x,y,times, ylab="Sine wave", type="p", col=rainbow(100)[x *10])

## changing line width - a whole-plot parameter
anim.plot(x, y, times, lwd=1:10, type="l")
          
## times as a single number
anim.plot(1:10, 1:10, times=5)
           
## incremental plot
anim.plot(1:10, 1:10, window=1:t)

## moving window
anim.plot(1:10, 1:10, window=(t-2):t)

## Formula interface
ChickWeight$chn <- as.numeric(as.factor(ChickWeight$Chick))
tmp <- anim.plot(weight ~ chn + Time, data=ChickWeight, col=as.numeric(Diet), 
     pch=as.numeric(Diet), speed=3)

# adding extra arguments:
replay(tmp, after=legend("topleft", legend=paste("Diet", 1:4), pch=1:4, col=1:4))
 
 ## Zooming in:
 x <- rnorm(4000); y<- rnorm(4000)
 x <- rep(x, 10); y <- rep(y, 10)
 xlims <- 4*2^(-(1:10/10))
 ylims <- xlims <- rbind(xlims, -xlims) 
 anim.plot(x, y, times=10, speed=5, xlim=xlims, ylim=ylims, 
       col=rgb(0,0,0,.3), pch=19)
 
 ## window.process to create a faded "trail":
 anim.plot(1:50, 1:50, speed=12, window=t:(t+5), 
       window.process=function(args, times){
         times <- times - min(times) 
         alpha <- times/max(times)
         alpha[is.na(alpha)] <- 1
         args$col <- rgb(0,0,0, alpha)
         return(args)
       })
       
 ## gapminder plot:
 pl <- palette(adjustcolor(rainbow(23), 1, .6, .6, .6, 
       offset=c(0,0,0,-0.1)))
 anim.plot(lifex ~ GDP + year, data=gm_data, log="x", 
      cex=sqrt(pop)*0.0004, pch=19, col=region, xlab="GDP", 
      ylab="Life expectancy", speed=10, subset=year > 1850 & !year \%\% 5)
 palette(pl)
 
 \dontrun{
 ## Earthquakes this week
 if (require('maps')) {
   eq = read.table(
       file="http://earthquake.usgs.gov/earthquakes/catalogs/eqs7day-M1.txt", 
       fill=TRUE, sep=",", header=TRUE)
   eq$time <- as.numeric(strptime(eq$Datetime, "\%A, \%B \%d, \%Y \%X UTC"))
 eq <- eq[-1,]
   map('world')
   maxdepth <- max(max(eq$Depth), 200)
   tmp <- anim.points(Lat ~ Lon + time, data=eq, cex=Magnitude, col=rgb(
         1-Depth/maxdepth, 0, Depth/maxdepth,.7), pch=19, speed=3600*12, 
         show=FALSE)   
   replay(tmp, before=map('world', fill=TRUE, col="wheat"))
 }
 
 
 ## Minard's plot
 if (require('maps')) {
   map('world', xlim=c(22, 40), ylim=c(52,58))
   title("March of the Grande Armee on Moscow")
   points(cities$long, cities$lat, pch=18)
   text(cities$long, cities$lat, labels=cities$city, pos=4, cex=.7)
   with(troops[troops$group==1,], anim.lines(x=long, 
         y=lat, window=t:(t+1), speed=3, lwd=survivors/10000))
}
}
}
