% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagesFromVideos.R
\name{imagesFromVideos}
\alias{imagesFromVideos}
\title{Extract frames from video for classification}
\usage{
imagesFromVideos(
  videos,
  outdir = tempfile(),
  format = "jpg",
  fps = NULL,
  frames = NULL,
  parallel = FALSE,
  nproc = 1
)
}
\arguments{
\item{videos}{dataframe of videos}

\item{outdir}{directory to save frames to}

\item{format}{output format for frames, defaults to jpg}

\item{fps}{frames per second, otherwise determine mathematically}

\item{frames}{number of frames to sample}

\item{parallel}{Toggle for parallel processing, defaults to FALSE}

\item{nproc}{number of processors to use if parallel, defaults to 1}
}
\value{
dataframe of still frames for each video
}
\description{
This function can take
}
\examples{
\dontrun{
frames <- imagesFromVideos(videos,outdir="C:\\\\Users\\\\usr\\\\Videos\\\\",frames=5)
}
}
