% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createClusterST.R
\name{createClusterST}
\alias{createClusterST}
\title{Create a short-term storage cluster}
\usage{
createClusterST(
  area,
  cluster_name,
  group = "Other1",
  storage_parameters = storage_values_default(),
  PMAX_injection = NULL,
  PMAX_withdrawal = NULL,
  inflows = NULL,
  lower_rule_curve = NULL,
  upper_rule_curve = NULL,
  add_prefix = TRUE,
  overwrite = FALSE,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{area}{The area where to create the cluster.}

\item{cluster_name}{Name for the cluster, it will prefixed by area name, unless you set \code{add_prefix = FALSE}.}

\item{group}{Group of the cluster, one of : "PSP_open", "PSP_closed", "Pondage", "Battery", "Other". It corresponds to the type of stockage.}

\item{storage_parameters}{\code{list } Parameters to write in the Ini file (see \code{Note}).}

\item{PMAX_injection}{modulation of charging capacity on an 8760-hour basis. The values are float between 0 and 1.}

\item{PMAX_withdrawal}{modulation of discharging capacity on an 8760-hour basis. The values are float between 0 and 1.}

\item{inflows}{imposed withdrawals from the stock for other uses, The values are integer.}

\item{lower_rule_curve}{This is the lower limit for filling the stock imposed each hour. The values are float between 0 and 1.}

\item{upper_rule_curve}{This is the upper limit for filling the stock imposed each hour. The values are float between 0 and 1.}

\item{add_prefix}{If \code{TRUE} (the default), \code{cluster_name} will be prefixed by area name.}

\item{overwrite}{Logical, overwrite the cluster or not.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Create a new ST-storage cluster for >= v8.6.0 Antares studies.
}
\note{
To write parameters to the \code{list.ini} file. You have function \code{storage_values_default()} who is called by default.
This function return \code{list} containing six parameters for cluster \code{st-storage}.
See example section.

To write data (.txt file), you have parameter for each output file :
\itemize{
\item PMAX-injection.txt
\item PMAX-withdrawal.txt
\item inflows.txt
\item lower-rule-curve.txt
\item upper-rule-curve.txt
}
}
\examples{
\dontrun{

# list for cluster parameters : 
storage_values_default()

# create a cluster by default (with default parameters values + default data values):
createClusterST(area = "my_area", 
               "my_cluster") 
  
# Read cluster in study                            
 # by default, cluster name is prefixed 
 # by the area name
levels(readClusterSTDesc()$cluster)
# > "my_area_my_cluster"

# create cluster with custom parameter and data
my_parameters <- storage_values_default()
my_parameters$efficiency <- 0.5
my_parameters$reservoircapacity <- 10000


inflow_data <- matrix(3, 8760)
ratio_data <- matrix(0.7, 8760)
createClusterST(area = "my_area", 
                "my_cluster",
                storage_parameters = my_parameters,
                PMAX_withdrawal = ratio_data, 
                inflows = inflow_data, 
                PMAX_injection = ratio_data, 
                lower_rule_curve = ratio_data, 
                upper_rule_curve = ratio_data)
}

}
\seealso{
\code{\link[=editClusterST]{editClusterST()}} to edit existing clusters, \code{\link[=readClusterSTDesc]{readClusterSTDesc()}} to read cluster,
\code{\link[=removeClusterST]{removeClusterST()}} to remove clusters.
}
