% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addConvergencePriceArea.R
\name{addConvergencePriceArea}
\alias{addConvergencePriceArea}
\title{addConvergencePriceArea}
\usage{
addConvergencePriceArea(antaresData = NULL)
}
\arguments{
\item{antaresData}{Object of class \code{antaresData} created with function
\code{\link[antaresRead]{readAntares}}. antaresData must contains areas and
links details hourly data with linkCapacity.}
}
\description{
This function computes priceConvergenceArea, priceConvergenceArea represent
the biggest system without congestion for one area.
}
\examples{
\dontrun{

  myData <- readAntares(areas = "all",
  links = "all",
  showProgress = FALSE,
  linkCapacity = TRUE,
  mcYears = "all")

  myDataRV <- removeVirtualAreas(x = myData,
  storageFlexibility = getAreas(c("psp", "hub")),
  production = getAreas("off"))

  addConvergencePriceArea(myData)
}
}
