% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAreas.R
\name{getAreas}
\alias{getAreas}
\alias{getDistricts}
\title{Select and exclude areas}
\usage{
getAreas(select = NULL, exclude = NULL, withClustersOnly = FALSE,
  regexpSelect = TRUE, regexpExclude = TRUE, opts = simOptions(),
  ignore.case = TRUE, districts = NULL)

getDistricts(select = NULL, exclude = NULL, regexpSelect = TRUE,
  regexpExclude = TRUE, opts = simOptions(), ignore.case = TRUE)
}
\arguments{
\item{select}{Character vector. If \code{regexpSelect} is TRUE, this vector is
interpreted as a list of regular expressions. Else it is interpreted as a
list of area names. If \code{NULL}, all areas are selected}

\item{exclude}{Character vector. If \code{regexpExclude} is TRUE, this vector is
interpreted as a list of regular expressions and each area validating one
of them is excluded. Else it is interpreted as list of area names to 
exclude. If \code{NULL}, not any area is excluded.}

\item{withClustersOnly}{Should the function return only nodes containing clusters ?}

\item{regexpSelect}{Is \code{select} a list of regular expressions ?}

\item{regexpExclude}{Is \code{exclude} a list of regular expressions ?}

\item{opts}{list of simulation parameters returned by the function
\code{\link{setSimulationPath}}}

\item{ignore.case}{Should the case be ignored when evaluating the regular
expressions ?}

\item{districts}{Names of districts. If this argument is not null, only areas belonging
to the specified districts are returned.}
}
\value{
A character vector containg the name of the areas/districts satisfying the 
rules defined by the parameters.
}
\description{
\code{getAreas} and \code{getDistricts} are utility functions that builds 
list of areas or districts by using regular expressions to select and/or 
exclude areas/districts
}
\seealso{
\code{\link{getLinks}}
}
