% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_options.R
\name{plotMapOptions}
\alias{plotMapOptions}
\alias{defaultTilesURL}
\alias{colorScaleOptions}
\title{Graphical options for plotMap}
\usage{
plotMapOptions(areaDefaultCol = "#DDDDE5", areaDefaultSize = 30,
  areaMaxSize = 50, areaMaxHeight = 50, areaChartColors = NULL,
  areaColorScaleOpts = colorScaleOptions(), labelMinSize = 8,
  labelMaxSize = 24, linkDefaultCol = "#BEBECE", linkDefaultSize = 3,
  linkMaxSize = 15, linkColorScaleOpts = colorScaleOptions(),
  legend = c("choose", "visible", "hidden"), tilesURL = defaultTilesURL(),
  preprocess = function(map) {     map })

defaultTilesURL()

colorScaleOptions(breaks = 5, domain = NULL, negCol = "#FF0000",
  zeroCol = "#FAFAFA", posCol = "#0000FF", naCol = "#EEEEEE",
  zeroTol = NULL, colors = NULL, levels = NULL)
}
\arguments{
\item{areaDefaultCol}{default color of areas.}

\item{areaDefaultSize}{default size of areas.}

\item{areaMaxSize}{maximal size of an area when it represents the value of some variable.}

\item{areaMaxHeight}{Maximal height of bars. Used only if a barchart representation is used.}

\item{areaChartColors}{Vector of colors to use in polar area charts and bar charts}

\item{areaColorScaleOpts}{List of options used to construct a continuous color scale. This list should
be generated with function \code{colorScaleOptions}.}

\item{labelMinSize}{minimal height of labels.}

\item{labelMaxSize}{maximal height of labels.}

\item{linkDefaultCol}{Default color of links.}

\item{linkDefaultSize}{Default line width of links.}

\item{linkMaxSize}{Maximal line width of a link when it represents the value of some variable.}

\item{linkColorScaleOpts}{List of options used to construct a continuous color scale. This list should
be generated with function \code{colorScaleOptions}.}

\item{legend}{Should the legend be displayed or not ? Default is to mask the legend but
add a button to display it. Other values are "visible" to make the legend
always visible and "hidden" to mask it.}

\item{tilesURL}{URL template used to get map tiles. The followign site 
provides some URLs;
\url{https://leaflet-extras.github.io/leaflet-providers/preview/}}

\item{preprocess}{A function that takes as argument a map and that returns a
modified version of this map. This parameter can be used to add extra
information on a map.}

\item{breaks}{Either a single number indicating the approximate number of colors to use, or
a vector of values at which values to change color. 
In the first case, the function tries to cut the data nicely, so the real 
number of colors used may vary.}

\item{domain}{Range of the data, ie. the range of possible values. If \code{NULL}, the
the range of the data is used}

\item{negCol}{color of the extreme negative value.}

\item{zeroCol}{color of the 0 value.}

\item{posCol}{Color of the extreme positive value.}

\item{naCol}{Color for missing values}

\item{zeroTol}{All values in the interval \code{\[-zeroTol, +zeroTol\]} are mapped to the
\code{zeroCol} color. If \code{NULL}, the function tries to pick a nice
value that is approximately equal to 1\% of the maximal value.}

\item{colors}{Vector of colors. If it is set and if user manually sets break points, then
these colors are used instead of the colors defined by parameters negCol,
zeroCol and posCol.}

\item{levels}{Vector of the distinct values a variable can take. Only used when the 
variable to represent is a categorical variable.}
}
\value{
A list with the values of the different graphical parameters.
}
\description{
These functions get and set options that control some graphical aspects 
of maps created with \code{\link{plotMap}}.
}
\examples{
\dontrun{
params <- plotMapOptions(areaDefaultCol = "red", linkDefaultCol = "orange")
plotMap(mydata, mylayout, options = params)
}

}
