% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/aop_graph_analysis.R
\name{aop_backdoor}
\alias{aop_backdoor}
\title{Backdoor Causal Network Analysis for AOPs}
\usage{
aop_backdoor(aop_graph, ke_coord, ao_coord, measureable_nodes = NULL)
}
\arguments{
\item{aop_graph}{a \code{graphNEL} object that encodes the AOP. Typically,
this would be output from the \code{convert_aop_to_graph function}.}

\item{ke_coord}{typically this is the molecular initiating event node, but
really, this is any node that you want as the starting/source point. For
instance, this is normally the point at which exposure to a stressor is
going to enter the AOP.}

\item{ao_coord}{typically this is the adverse outcome node.}

\item{measureable_nodes}{this param is not used yet. In the future this node
will be a \code{vector} of the nodes where an assay is available to measure
the node. In a future release this param will focus the backdoor algorithm
on finding only those nodes for which measurements can actually be taken, as
opposed to causal nodes regardless of our ability to measure them.
This allows for the assumption that AOP key events may or may not be
measureable.}
}
\value{
causal_nodes \code{vector} a vector of the names of the causal nodes.
}
\description{
Performs a backdoor causal network analysis to idenitfy nodes/key events
which are sufficient to infer causality.
}
\details{
This function performs Pearl's backdoor analysis. Whereas Pearl was
interested in identifying nodes which need to be measured to make a causal
statement, we are interested in identifying those nodes/key events which
need to measured to say that an adverse outcome is likely to occur. It's
essentially the same thing as Pearl, only a slightly different
interpretation.
}
\examples{
steatosis_json_file <- system.file("extdata", "steatosis_aop_json.cyjs",
package = "aop")
steatosis_aop <- convert_cytoscape_to_aop(steatosis_json_file)
steatosis_aop_graph <- convert_aop_to_graph(steatosis_aop)
aop_backdoor(steatosis_aop_graph, "391", "388")
}

