% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_grid}
\alias{ax_grid}
\title{Add grids on chart}
\usage{
ax_grid(
  ax,
  show = NULL,
  borderColor = NULL,
  strokeDashArray = NULL,
  position = NULL,
  xaxis = NULL,
  yaxis = NULL,
  row = NULL,
  column = NULL,
  padding = NULL,
  ...
)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{show}{Logical. To show or hide grid area (including xaxis / yaxis)}

\item{borderColor}{Colors of grid borders / lines.}

\item{strokeDashArray}{Creates dashes in borders of svg path. Higher number creates more space between dashes in the border.}

\item{position}{Whether to place grid behind chart paths of in front. Available options for position: \code{"front"} or \code{"back"}}

\item{xaxis}{A list of parameters.}

\item{yaxis}{A list of parameters.}

\item{row}{A list of parameters.}

\item{column}{A list of parameters.}

\item{padding}{A list of parameters.}

\item{...}{Additional parameters.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Add grids on chart
}
\note{
See \url{https://apexcharts.com/docs/options/grid/}
}
\examples{
library(dplyr)
data("mpg", package = "ggplot2")

# Hide Y-axis and gridelines
apex(
  data = count(mpg, manufacturer),
  mapping = aes(x = manufacturer, y = n)
) \%>\% 
  ax_grid(show = FALSE)

# just grid lines
apex(
  data = count(mpg, manufacturer),
  mapping = aes(x = manufacturer, y = n)
) \%>\% 
  ax_grid(yaxis = list(lines = list(show = FALSE)))


# both x & y
data("economics", package = "ggplot2")
apex(
  data = economics,
  mapping = aes(x = date, y = psavert),
  type = "line"
) \%>\% 
  ax_grid(
    yaxis = list(lines = list(show = TRUE)),
    xaxis = list(lines = list(show = TRUE))
  )
}
