% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tooltip.R
\name{set_tooltip_fixed}
\alias{set_tooltip_fixed}
\title{Fixed tooltip}
\usage{
set_tooltip_fixed(
  ax,
  position = c("topLeft", "topRight", "bottomLeft", "bottomRight"),
  offsetX = NULL,
  offsetY = NULL
)
}
\arguments{
\item{ax}{An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.}

\item{position}{Predefined position: \code{"topLeft"}, \code{"topRight"},
\code{"bottomLeft"} or \code{"bottomRight"}.}

\item{offsetX}{Sets the left offset for the tooltip container in fixed position.}

\item{offsetY}{Sets the top offset for the tooltip container in fixed position.}
}
\value{
An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.
}
\description{
Fixed tooltip
}
\examples{

library(apexcharter)
data("economics", package = "ggplot2")

apex(
  data = tail(economics, 350), 
  mapping = aes(x = date, y = uempmed),
  type = "line"
) \%>\% 
  set_tooltip_fixed()
}
