% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivePHMM.R
\name{map}
\alias{map}
\title{Optimized profile HMM construction.}
\usage{
map(x, seqweights = NULL, residues = NULL, gap = "-",
  endchar = "?", pseudocounts = "background", lambda = 0,
  qa = NULL, qe = NULL, cpp = TRUE)
}
\arguments{
\item{x}{a matrix of aligned sequences. Accepted modes are "character"
and "raw" (the latter being used for "DNAbin" and "AAbin" objects).}

\item{seqweights}{either NULL (default; all sequences are given
weights of 1) or a numeric vector the same length as \code{x} representing
the sequence weights used to derive the model.}

\item{residues}{either NULL (default; emitted residues are automatically
detected from the sequences), a case sensitive character vector
specifying the residue alphabet, or one of the character strings
"RNA", "DNA", "AA", "AMINO". Note that the default option can be slow for
large lists of character vectors. Furthermore, the default setting
\code{residues = NULL} will not detect rare residues that are not present
in the sequences, and thus will not assign them emission probabilities
in the model. Specifying the residue alphabet is therefore
recommended unless x is a "DNAbin" or "AAbin" object.}

\item{gap}{the character used to represent gaps in the alignment matrix
(if applicable). Ignored for \code{"DNAbin"} or \code{"AAbin"} objects.
Defaults to "-" otherwise.}

\item{endchar}{the character used to represent unknown residues in
the alignment matrix (if applicable). Ignored for \code{"DNAbin"} or
\code{"AAbin"} objects. Defaults to "?" otherwise.}

\item{pseudocounts}{character string, either "background", Laplace"
or "none". Used to account for the possible absence of certain
transition and/or emission types in the input sequences.
If \code{pseudocounts = "background"} (default), pseudocounts
are calculated from the background transition and emission
frequencies in the sequences.
If \code{pseudocounts = "Laplace"} one of each possible transition
and emission type is added to the transition and emission counts.
If \code{pseudocounts = "none"} no pseudocounts are added (not
generally recommended, since low frequency transition/emission types
may be excluded from the model).
Alternatively this argument can be a two-element list containing
a matrix of transition pseudocounts
as its first element and a matrix of emission pseudocounts as its
second.}

\item{lambda}{penalty parameter used to favour models with fewer match
states. Equivalent to the log of the prior probability of marking each
column (Durbin et al 1998, chapter 5.7).}

\item{qa}{an optional named 9-element vector of background transition
probabilities with \code{dimnames(qa) = c("DD", "DM", "DI", "MD", "MM",
"MI", "ID", "IM", "II")}, where M, I and D represent match, insert and
delete states, respectively. If \code{NULL}, background transition
probabilities are estimated from the sequences.}

\item{qe}{an optional named vector of background emission probabilities
the same length as the residue alphabet (i.e. 4 for nucleotides and 20
for amino acids) and with corresponding names (i.e. \code{c("A", "T",
"G", "C")} for DNA). If \code{qe = NULL}, background emission probabilities
are automatically derived from the sequences.}

\item{cpp}{logical, indicates whether the dynamic programming matrix
should be filled using compiled C++ functions (default; many times faster).
The FALSE option is primarily retained for bug fixing and experimentation.}
}
\value{
a logical vector with length = ncol(x) indicating the columns to be
  assigned as match states (\code{TRUE}) and those assigned as inserts
  (\code{FALSE}).
}
\description{
Assigns match and insert states to alignment columns using the maximum
  \emph{a posteriori} algorithm outlined in Durbin et al (1998) chapter 5.7.
}
\details{
see Durbin et al (1998) chapter 5.7 for details of
  the maximum \emph{a posteriori} algorithm for optial match and insert
  state assignment.
}
\examples{
## Maximum a posteriori assignment of match states to the small
## alignment example in Figure 5.3, Durbin et al (1998)
data(globins)
map(globins)
}
\references{
Durbin R, Eddy SR, Krogh A, Mitchison G (1998) Biological
  sequence analysis: probabilistic models of proteins and nucleic acids.
  Cambridge University Press, Cambridge, United Kingdom.
}
\seealso{
\code{\link{derivePHMM}}
}
\author{
Shaun Wilkinson
}
