% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_weighting.R
\name{apollo_weighting}
\alias{apollo_weighting}
\title{Applies weights}
\usage{
apollo_weighting(P, apollo_inputs, functionality)
}
\arguments{
\item{P}{List of vectors, matrices or 3-dim arrays. Likelihood of the model components.}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{functionality}{Character. Can take different values depending on desired output of \code{apollo_probabilities}.
\itemize{
  \item \code{"estimate"} For model estimation, returns probabilities of chosen alternatives.
  \item \code{"prediction"} For model predictions, returns probabilities of all alternatives.
  \item \code{"validate"} Validates input.
  \item \code{"zero_LL"} Return probabilities with all parameters at zero.
  \item \code{"conditionals"} For conditionals, returns probabilities of chosen alternatives.
  \item \code{"output"} Checks that the model is well defined.
  \item \code{"raw"} For debugging, returns probabilities of all alternatives
}}
}
\value{
The likelihood (i.e. probability in the case of choice models) of the model in the appropriate form for the 
        given functionality, multiplied by individual-specific weights.
}
\description{
Applies weights to individual observations in likelihood function.
}
\details{
This function should be called inside \code{apollo_probabilities}, near the end of it, just before \code{return(P)}.
}
