% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_fitsTest.R
\name{apollo_fitsTest}
\alias{apollo_fitsTest}
\title{Compares log-likelihood of model across categories}
\usage{
apollo_fitsTest(model, apollo_probabilities, apollo_inputs, fitsTest_settings)
}
\arguments{
\item{model}{Model object. Estimated model object as returned by function \link{apollo_estimate}.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item \strong{\code{apollo_beta}}: Named numeric vector. Names and values of model parameters.
  \item \strong{\code{apollo_inputs}}: List containing options of the model. See \link{apollo_validateInputs}.
  \item \strong{\code{functionality}}: Character. Can be either \strong{\code{"components"}}, \strong{\code{"conditionals"}}, \strong{\code{"estimate"}} (default), \strong{\code{"gradient"}}, \strong{\code{"output"}}, \strong{\code{"prediction"}}, \strong{\code{"preprocess"}}, \strong{\code{"raw"}}, \strong{\code{"report"}}, \strong{\code{"shares_LL"}}, \strong{\code{"validate"}} or \strong{\code{"zero_LL"}}.
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{fitsTest_settings}{List. Contains settings for this function. User input is required for all settings except those with a default or marked as optional. 
\itemize{
     \item \strong{subsamples}: Named list of boolean vectors. Each element of the list defines whether a given observation belongs to a given subsample (e.g. by sociodemographics).
}}
}
\value{
Matrix with average log-likelihood at observation level per category (invisibly).
}
\description{
Given the estimates of a model, it compares the log-likelihood at the observation level across categories of observations.
}
\details{
Prints a table comparing the average log-likelihood at the observation level for each category.
}
