% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport_plan.R
\name{transport_plan}
\alias{transport_plan}
\title{Optimal transport plans}
\usage{
transport_plan(
  X,
  Y,
  a = NULL,
  b = NULL,
  p = 2,
  ground_p = 2,
  observation.orientation = c("rowwise", "colwise"),
  method = transport_options(),
  ...
)
}
\arguments{
\item{X}{The covariate data of the first sample.}

\item{Y}{The covariate data of the second sample.}

\item{a}{Optional. Empirical measure of the first sample}

\item{b}{Optional. Empirical measure of the second sample}

\item{p}{The power of the Wasserstein distance}

\item{ground_p}{The power of the Lp norm}

\item{observation.orientation}{Are observations by row ("rowwise") or column ("colwise").}

\item{method}{Which transportation method to use. See [transport_options][transport_options]}

\item{...}{Additional arguments for various methods:
\itemize{
\item{"niter":}{ The number of iterations to use for the entropically penalized optimal transport distances}
\item{"epsilon":}{ The multiple of the median cost to use as a penalty in the entropically penalized optimal transport distances}
\item{"unbiased":}{ If using Sinkhorn distances, should the distance be de-biased? (TRUE/FALSE)}
\item{"nboot":}{ If using sliced Wasserstein distances, specify the number of Monte Carlo samples}
}}
}
\value{
a list with slots "tplan" and "cost". "tplan" is the optimal transport plan and "cost" is the optimal transport distance.
}
\description{
Optimal transport plans
}
\examples{
set.seed(203987)
n <- 100
d <- 10
x <- matrix(rnorm(d*n), nrow=d, ncol=n)
y <- matrix(rnorm(d*n), nrow=d, ncol=n)
#get hilbert sort orders for x in backwards way
transx <- transport_plan(X=x, Y=x, ground_p = 2, p = 2, 
                         observation.orientation =  "colwise", 
                         method = "hilbert")
}
