% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotColorMixture.R
\name{plotColorMixture}
\alias{plotColorMixture}
\title{Visualize Spectral Mixing of Munsell Colors}
\usage{
plotColorMixture(
  x,
  w = rep(1, times = length(x))/length(x),
  swatch.cex = 6,
  label.cex = 0.85
)
}
\arguments{
\item{x}{vector of colors in Munsell notation}

\item{w}{vector of proportions, can sum to any number}

\item{swatch.cex}{scaling factor for color swatch}

\item{label.cex}{scaling factor for swatch labels}
}
\value{
lattice graphics object
}
\description{
Lattice visualization demonstrating subtractive mixtures of colors in Munsell notation and associated spectra.
}
\author{
D.E. Beaudette
}
