% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSoilDepthClass.R
\name{getSoilDepthClass}
\alias{getSoilDepthClass}
\title{Generate Soil Depth Class Matrix}
\usage{
getSoilDepthClass(
  f,
  depth.classes = c(very.shallow = 25, shallow = 50, mod.deep = 100, deep = 150,
    very.deep = 10000),
  ...
)
}
\arguments{
\item{f}{a SoilProfileCollection object}

\item{depth.classes}{a named vector of classes and depth breaks}

\item{\dots}{arguments passed to \code{\link{estimateSoilDepth}}}
}
\value{
a \code{data.frame} containing soil depth and depth class for each
profile, see examples
}
\description{
Generate a boolean matrix of soil depth classes, actual soil depth class, and estimate of soil depth from a \code{SoilProfileCollection} object. Soil depths are estimated using pattern matching applied to horizon designations, by \code{\link[=estimateSoilDepth]{estimateSoilDepth()}}. The default REGEX pattern (\code{p = 'Cr|R|Cd'}) will match most "contacts" described using the USDA / Soil Taxonomy horizon designation conventions.
}
\examples{

data(sp1)
depths(sp1) <- id ~ top + bottom

# generate depth-class matrix
sdc <- getSoilDepthClass(sp1, name = 'name')

# inspect
head(sdc)

# join back into sp1 as site-level data
site(sp1) <- sdc

\dontrun{
# sample data
data(gopheridge, package='soilDB')

getSoilDepthClass(gopheridge, name = 'hzname')
}

}
\seealso{
\code{\link{estimateSoilDepth}}
}
\author{
D.E. Beaudette and J.M. Skovlin
}
\keyword{manip}
