% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragmentClasses.R
\name{fragmentClasses}
\alias{fragmentClasses}
\title{Coarse Fragment Class Labels and Diameter}
\usage{
fragmentClasses(
  sys = c("usda_simplified", "usda", "international", "unified", "aashto",
    "mod.wentworth"),
  flat = FALSE,
  rounded = FALSE
)
}
\arguments{
\item{sys}{character, length 1. This is an abbreviated name used to select class labels and fragment diameter.}

\item{flat}{logical. Fragments are flat, only used by USDA systems.}

\item{rounded}{logical. Fragments are rounded, only used by AASHTO system.}
}
\value{
named vector of fragment diameter in mm
}
\description{
This is a convenience function for accessing coarse fragment class labels and associated diameter (mm), as defined in various classification systems such as USDA, Unified, and AASHTO.
}
\examples{

# use default system: "usda_simplified"
fragmentClasses()
fragmentClasses(flat = TRUE)

fragmentClasses(sys = 'usda')
fragmentClasses(sys = 'USDA', flat = TRUE)

fragmentClasses(sys = 'international')

fragmentClasses(sys = 'unified')

fragmentClasses(sys = 'aashto')
fragmentClasses(sys = 'aashto', rounded = TRUE)

fragmentClasses(sys = 'mod.wentworth')

}
\references{
Schoeneberger, P.J., D.A. Wysocki, E.C. Benham, and Soil Survey Staff. 2012. Field book for describing and sampling soils, Version 3.0. Natural Resources Conservation Service, National Soil Survey Center, Lincoln, NE.
}
\seealso{
\code{\link[=fragmentSieve]{fragmentSieve()}}
}
