% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arakno.R
\name{countries}
\alias{countries}
\title{Get taxon countries from WSC.}
\usage{
countries(tax)
}
\arguments{
\item{tax}{A taxon name or vector with taxa names.}
}
\value{
A vector with country ISO codes. Family and genera names will be converted to species.
}
\description{
Get countries of taxa from the World Spider Catalogue textual descriptions.
}
\details{
Countries based on the interpretation of the textual descriptions available at the World Spider Catalogue (2022). These might be only approximations to country level and should be taken with caution.
}
\examples{
\dontrun{
countries("Iberesia machadoi")
countries(c("Iberesia machadoi", "Nemesia"))
}
}
\references{
World Spider Catalog (2022). World Spider Catalog. Version 23.0. Natural History Museum Bern, online at http://wsc.nmbe.ch. doi: 10.24436/2.
}
