% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aw_interpolate.R
\name{aw_interpolater}
\alias{aw_interpolater}
\title{Carry Out Interpolation}
\usage{
aw_interpolater(source, sid, value, target, tid, type, weight)
}
\arguments{
\item{source}{A \code{sf} object with data to be interpolated}

\item{sid}{A unique identification number within \code{source}}

\item{value}{A column within \code{source} to be interpolated}

\item{target}{A \code{sf} object that data should be interpolated to}

\item{tid}{A unique identification number within \code{target}}

\item{type}{One of either \code{"extensive"} (if the data are spatially extensive e.g.
population counts), \code{"intensive"} (if the data are spatially intensive e.g.
population density), or \code{"mixed"} (if the data include both extensive and
intensive values). If \code{"extensive"}, the sum is returned for the interpolated
value. If \code{"intensive"}, the mean is returned for the interpolated value.
If \code{"mixed"}, vectors named \code{"extensive"} and \code{"intensive"} containing
the relevant variable names should be specified in the dots.}

\item{weight}{For \code{"extensive"} interpolations; should be either \code{"total"} or
\code{"sum"}.}
}
\value{
A \code{sf} object or tibble with \code{value} interpolated into
   the \code{target} data.
}
\description{
\code{aw_interpolater} performs pipeline of interpolation specific
    calculations with \code{aw_intersect}, \code{aw_total}, \code{aw_weight},
    \code{aw_calculate}, and \code{aw_aggregate}. The interpolated total is then
    verified against the total calculated from the source data using \code{aw_verify}.
}
