% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPath.R
\name{setPath}
\alias{setPath}
\title{Set the root path}
\usage{
setPath(root = NULL)
}
\arguments{
\item{root}{[\code{character(1)}]\cr path to the root directory that contains
or shall contain an areal database.}
}
\value{
No return value, called for the side effect of creating the
  directory structure of the new areal database and a new environment that
  contains the database metadata.
}
\description{
Initiate a geospatial database or register a database that exists at the root
path.
}
\details{
This is the first function that is run in a project, as it initiates
  the areal database by creating the default sub-directories and initial
  inventory tables. When a database has already been set up, this function is
  used to register that path in the options of the current R session.
}
\examples{
setPath(root = paste0(tempdir(), "/newDB"))
}
