% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARMADA.R
\name{ARMADA}
\alias{ARMADA}
\title{Scores of all the covariates present in X, given the vector Y of the response.}
\usage{
ARMADA(X, Y, nclust = NULL, clusterType = c("PSOCK", "FORK"),
  parallel = FALSE)
}
\arguments{
\item{X}{the matrix (or data.frame) of covariates, dimension n*p (n is the sample size, p the number of covariates). X must have rownames, which are the names of the n subjects (i.e. the user ID of the n subjects). X must have colnames, which are the names of the p covariates.}

\item{Y}{the vector of the response, length n.}

\item{nclust}{the number of clusters in the covariates dataset X.}

\item{clusterType}{to precise the type of cluster of the machine. Possible choices: "PSOCK", or "FORK" (for UNIX or MAC systems, but not for WINDOWS).}

\item{parallel}{=  TRUE if the calculus are made in parallel (default choice is FALSE).}
}
\value{
a 3-list with: "tree" which is the dendrogram of the data X, "nclust" which is a proposition of the number of clusters in the data X, "result" which is a data.frame with p rows and 2 columns, the first column gives the names of the covariates, the second column is the scores of the covariates.
}
\description{
Scores of all the covariates present in X, given the vector Y of the response.
}
\examples{
library(ClustOfVar)
library(impute)
library(FAMT)
library(VSURF)
library(glmnet)
library(anapuce)
library(qvalue)

set.seed(1)
p <- 40
n <- 30
indexRow <- paste0("patient",1:n)
indexCol <- paste0("G",1:p)
X <- matrix(rnorm(p*n),ncol=p)
colnames(X) <- indexCol
rownames(X) <- indexRow
Y <- c(rep(-1,n/2), rep(1,n/2))
X[,1:4] <-  X[,1:4] + matrix(rnorm(n*4, mean=2*Y, sd=1), ncol=4)
Y<-as.factor(Y)
resultat <- ARMADA(X,Y, nclust=1)
\dontrun{
X<-toys.data$x
Y<-toys.data$Y
result<-ARMADA(X,Y, nclust=2)
}
}
