% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arsenal.R
\docType{package}
\name{arsenal}
\alias{arsenal}
\alias{arsenal-package}
\title{An Arsenal of 'R' Functions for Large-Scale Statistical Summaries}
\description{
An Arsenal of 'R' functions for large-scale statistical summaries,
  which are streamlined to work within the latest reporting tools in 'R' and 'RStudio' and
  which use formulas and versatile summary statistics for summary tables and models.
}
\section{Functions}{


Below are listed some of the most widely used functions available in \code{arsenal}:

\code{\link{tableby}}: Summary statistics Of a set of independent variables by a categorical variable.

\code{\link{modelsum}}: Fit models over each of a set of independent variables with a response variable.

\code{\link{freqlist}}: Approximate the output from SAS's \code{PROC FREQ} procedure when using the \code{/list} option of the \code{TABLE} statement.

\code{\link{write2word}}, \code{\link{write2html}}, \code{\link{write2pdf}}: Functions to generate a word, html, or pdf document containing a single table.

\code{\link{formulize}}: A shortcut to generate one-, two-, or many-sided formulas.

\code{\link{mdy.Date}} and \code{\link{Date.mdy}}: Convert numeric dates for month, day, and year to Date object, and vice versa.
}

\section{Data}{


\code{\link{mockstudy}}: Mock study data for examples.
}
\examples{
library(arsenal)

}

